/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRuleParser;
import com.ibm.team.enterprise.buildablesubset.common.IWorkItemBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.impl.WorkItemBuildSubsetRule;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;

public class WorkItemBuildSubsetRuleParser
implements IBuildSubsetRuleParser {
    @Override
    public boolean canParseRule(IBuildSubsetRule rule) {
        return rule instanceof IWorkItemBuildSubsetRule;
    }

    @Override
    public boolean canParseRule(String ruleContent) {
        try {
            JSONObject jsonObj = JSONObject.parse((Reader)new StringReader(ruleContent));
            String id = (String)jsonObj.get((Object)"id");
            if (id.equals(IWorkItemBuildSubsetRule.ID)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    @Override
    public IBuildSubsetRule parseRule(String content) throws TeamRepositoryException {
        try {
            WorkItemBuildSubsetRule rule = new WorkItemBuildSubsetRule();
            JSONObject jsonObj = JSONObject.parse((Reader)new StringReader(content));
            JSONArray jsonArray = (JSONArray)jsonObj.get((Object)"workItems");
            if (jsonArray != null && !jsonArray.isEmpty()) {
                Iterator iterator = jsonArray.iterator();
                while (iterator.hasNext()) {
                    String workItem = (String)((JSONObject)iterator.next()).get((Object)"workItem");
                    if (!this.isValidUUID(workItem)) continue;
                    rule.addWorkItem((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workItem), null));
                }
            }
            boolean isIncludeChildren = Boolean.parseBoolean((String)jsonObj.get((Object)"isIncludeChildren"));
            boolean isDynamic = Boolean.parseBoolean((String)jsonObj.get((Object)"isDynamic"));
            rule.setIncludeChildren(isIncludeChildren);
            rule.setDynamic(isDynamic);
            return rule;
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    @Override
    public String toJSON(IBuildSubsetRule rule) {
        JSONObject jsonObject = new JSONObject();
        if (rule instanceof IWorkItemBuildSubsetRule) {
            JSONArray jsonArray = new JSONArray();
            IWorkItemBuildSubsetRule workItemRule = (IWorkItemBuildSubsetRule)rule;
            for (IWorkItemHandle workItemHandle : workItemRule.getWorkItemHandles()) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put((Object)"workItem", (Object)workItemHandle.getItemId().getUuidValue());
                jsonArray.add((Object)jsonObj);
            }
            jsonObject.put((Object)"workItems", (Object)jsonArray);
            jsonObject.put((Object)"id", (Object)IWorkItemBuildSubsetRule.ID);
            jsonObject.put((Object)"isIncludeChildren", (Object)String.valueOf(workItemRule.isIncludeChildren()));
            jsonObject.put((Object)"isDynamic", (Object)String.valueOf(workItemRule.isDynamic()));
        }
        return jsonObject.toString();
    }

    private boolean isValidUUID(String uuidValue) {
        if (uuidValue == null || uuidValue.equals("")) {
            return false;
        }
        try {
            UUID.valueOf((String)uuidValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

