/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyRegistry;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;

public class WorkItemWorkingCopyManager
implements IWorkItemWorkingCopyManager {
    private WorkItemWorkingCopyRegistry fRegistry;
    private String fOwner;
    private boolean fWriteable;
    private boolean fShared;
    private List<IWorkItemHandle> fConnections = Collections.synchronizedList(new ArrayList());
    private InternalListener fInternalListener = new InternalListener();
    private ListenerList fWorkItemListeners = new ListenerList();
    private ListenerList fWorkingCopyListeners = new ListenerList();

    public WorkItemWorkingCopyManager(WorkItemWorkingCopyRegistry registry, String owner, boolean writeable, boolean shared) {
        this.fRegistry = registry;
        this.fOwner = owner;
        this.fWriteable = writeable;
        this.fShared = shared;
    }

    @Override
    public void connect(IWorkItemHandle handle, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fRegistry.connect((IWorkItemWorkingCopyManager)this, handle, profile, monitor);
    }

    @Override
    public void connect(List<? extends IWorkItemHandle> handles, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fRegistry.connect((IWorkItemWorkingCopyManager)this, handles, profile, monitor);
    }

    @Override
    public void connectCurrent(IWorkItemHandle handle, ItemProfile profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fRegistry.connectCurrent((IWorkItemWorkingCopyManager)this, handle, profile, monitor);
    }

    @Override
    public void connectCurrent(List<? extends IWorkItemHandle> handles, ItemProfile<IWorkItem> profile, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fRegistry.connectCurrent((IWorkItemWorkingCopyManager)this, handles, profile, monitor);
    }

    @Override
    public boolean connectLocal(IWorkItemHandle handle, ItemProfile<IWorkItem> profile) {
        return this.fRegistry.connectLocal(this, handle, profile);
    }

    @Override
    public IWorkItemHandle connectNew(IWorkItemType workItemType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fRegistry.connectNew((IWorkItemWorkingCopyManager)this, workItemType, monitor);
    }

    @Override
    public WorkItemWorkingCopy getWorkingCopy(IWorkItemHandle handle) {
        return this.fRegistry.getWorkingCopy(this, handle);
    }

    @Override
    public void disconnect(IWorkItemHandle handle) {
        this.fRegistry.disconnect(this, handle);
    }

    @Override
    public void refresh(IWorkItemHandle handle) {
        this.fRegistry.refresh(this, handle);
    }

    @Override
    public void refreshWithCurrent(IWorkItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fRegistry.refreshWithCurrent(this, handle, monitor);
    }

    @Override
    public void refreshLinksForGlobalConfigurationChange(IWorkItemHandle handle) {
        this.fRegistry.refreshLinksForGlobalConfigurationChange(this, handle);
    }

    public void mergeWithCurrent(IWorkItemHandle handle, boolean dropUnmergableChanges, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fRegistry.mergeWithCurrent(this, handle, dropUnmergableChanges, monitor);
    }

    @Override
    public void revert(IWorkItemHandle handle) {
        this.fRegistry.revert(this, handle);
    }

    @Override
    public IDetailedStatus save(WorkItemWorkingCopy[] copies, IProgressMonitor monitor) throws TeamRepositoryException, MultiStaleDataException {
        return this.fRegistry.save(this, copies, monitor);
    }

    @Override
    public List<IDetailedStatus> delete(List<IWorkItemHandle> handles, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fRegistry.delete(this, handles, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorkItemListener(IWorkItemListener listener) {
        ListenerList listenerList = this.fWorkItemListeners;
        synchronized (listenerList) {
            this.fWorkItemListeners.add((Object)listener);
            if (this.fWorkItemListeners.size() == 1) {
                this.fRegistry.addWorkItemListener(this.fInternalListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorkItemListener(IWorkItemListener listener) {
        ListenerList listenerList = this.fWorkItemListeners;
        synchronized (listenerList) {
            this.fWorkItemListeners.remove((Object)listener);
            if (this.fWorkItemListeners.size() == 0) {
                this.fRegistry.removeWorkItemListener(this.fInternalListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorkingCopyListener(IWorkingCopyListener listener) {
        ListenerList listenerList = this.fWorkingCopyListeners;
        synchronized (listenerList) {
            this.fWorkingCopyListeners.add((Object)listener);
            if (this.fWorkingCopyListeners.size() == 1) {
                this.fRegistry.addWorkingCopyListener(this.fInternalListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorkingCopyListener(IWorkingCopyListener listener) {
        ListenerList listenerList = this.fWorkingCopyListeners;
        synchronized (listenerList) {
            this.fWorkingCopyListeners.remove((Object)listener);
            if (this.fWorkingCopyListeners.size() == 0) {
                this.fRegistry.removeWorkingCopyListener(this.fInternalListener);
            }
        }
    }

    @Override
    public void beginCompoundWorkItemChange(IWorkItemHandle handle) {
        this.fRegistry.beginCompoundWorkItemChange(handle);
    }

    @Override
    public void endCompoundWorkItemChange(IWorkItemHandle handle) {
        this.fRegistry.endCompoundWorkItemChange(handle);
    }

    @Override
    public void applyLinksUpdate(IWorkItemHandle handle, List<ILink> links) {
        this.fRegistry.applyLinksUpdate(this, handle, links);
    }

    @Override
    public void dispose() {
        Object listener;
        Assert.isTrue((!this.fShared ? 1 : 0) != 0);
        Object[] objectArray = this.fWorkItemListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            this.removeWorkItemListener((IWorkItemListener)listener);
            ++n2;
        }
        objectArray = this.fWorkingCopyListeners.getListeners();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            listener = objectArray[n2];
            this.removeWorkingCopyListener((IWorkingCopyListener)listener);
            ++n2;
        }
        for (IWorkItemHandle handle : new ArrayList<IWorkItemHandle>(this.fConnections)) {
            this.fRegistry.disconnect(this, handle);
        }
        Assert.isTrue((boolean)this.fConnections.isEmpty());
        this.fRegistry = null;
        this.fConnections = null;
    }

    public boolean isWriteable() {
        return this.fWriteable;
    }

    public String getOwner() {
        return this.fOwner;
    }

    public void addConnection(IWorkItemHandle handle) {
        this.fConnections.add(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(IWorkItemHandle handle) {
        List<IWorkItemHandle> list = this.fConnections;
        synchronized (list) {
            Iterator<IWorkItemHandle> iter = this.fConnections.iterator();
            while (iter.hasNext()) {
                if (!handle.sameItemId((IItemHandle)iter.next())) continue;
                iter.remove();
                return;
            }
            Assert.isTrue((boolean)false);
        }
    }

    public void internalRefresh(IWorkItem source) {
        this.fRegistry.internalRefresh(this, source);
    }

    public WorkItemWorkingCopy createNewUnconnected(IWorkItemType workItemType, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fRegistry.createNewUnconnected(workItemType, monitor);
    }

    public WorkItemWorkingCopy createNewUnconnected(IWorkItem workItem) {
        return this.fRegistry.createNewUnconnected(workItem);
    }

    public void connectNew(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fRegistry.connectNew((IWorkItemWorkingCopyManager)this, workingCopy, monitor);
    }

    public void refreshWithCurrent(IWorkItemHandle handle, boolean checkNotDirty, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fRegistry.refreshWithCurrent(this, handle, checkNotDirty, monitor);
    }

    public List<ILink> findCachedLinks(IWorkItemHandle handle) {
        return this.fRegistry.findCachedLinks(handle);
    }

    public void joinEventDispatcher() {
        this.fRegistry.joinEventDispatcher();
    }

    @Override
    public void markAsDeleted(IWorkItemHandle[] handles) {
        if (handles == null || handles.length == 0) {
            return;
        }
        this.fRegistry.addToDeleted(handles);
    }

    private class InternalListener
    implements IWorkItemListener,
    IWorkingCopyListener {
        private InternalListener() {
        }

        @Override
        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            Object[] objectArray = WorkItemWorkingCopyManager.this.fWorkItemListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IWorkItemListener)listener).workItemAttributeChanged(event);
                ++n2;
            }
        }

        @Override
        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
            Object[] objectArray = WorkItemWorkingCopyManager.this.fWorkItemListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IWorkItemListener)listener).workItemAttributeDependencyChanged(event);
                ++n2;
            }
        }

        @Override
        public void workingCopyEvent(WorkingCopyEvent event) {
            Object[] objectArray = WorkItemWorkingCopyManager.this.fWorkingCopyListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IWorkingCopyListener)listener).workingCopyEvent(event);
                ++n2;
            }
        }
    }
}

