/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.workitem.client.internal.util.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class FileContentTypeUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IContentType getContentType(File file) throws CoreException {
        IContentType iContentType;
        if (!Platform.isRunning()) {
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            iContentType = Platform.getContentTypeManager().findContentTypeFor((InputStream)stream, file.getName());
            if (stream == null) return iContentType;
        }
        catch (IOException x) {
            try {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.client", 4, Messages.InternalContentTypeUtils_EXCEPTION_READING_EXTERNAL_FILE, (Throwable)x));
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return iContentType;
        }
        catch (IOException iOException) {}
        return iContentType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IContentDescription getContentDescription(IFileStore file) throws CoreException {
        IContentDescription iContentDescription;
        if (!Platform.isRunning()) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = file.openInputStream(0, null);
            iContentDescription = Platform.getContentTypeManager().getDescriptionFor(stream, file.getName(), IContentDescription.ALL);
            if (stream == null) return iContentDescription;
        }
        catch (IOException x) {
            try {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.client", 4, Messages.InternalContentTypeUtils_EXCEPTION_READING_EXTERNAL_FILE, (Throwable)x));
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return iContentDescription;
        }
        catch (IOException iOException) {}
        return iContentDescription;
    }
}

