/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTComponent;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTStream;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CTWvcmConfiguration;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class CTUcmView
extends CTView {
    private static final String PROJECT_PREFIX = "DO_NOT_USE_";
    private static final String PROJECT_SUFFIX = "_PROJECT";
    private static final String STREAM_SUFFIX = "_STREAM";
    private String _latestCompositeBaseline;

    CTUcmView(Location location, CTProvider provider) throws WvcmException {
        super(location, provider);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.CONFIGURATION_ROOT_FOLDER_HOME)) {
            return this.computeConfigRootFolderHome(this.provider().getDefaultCompVobTag(feedback), feedback);
        }
        if (propertyName.equals((Object)Workspace.ACTIVITY_FOLDER_LIST)) {
            return this.getActivityFolderLocation(feedback);
        }
        if (propertyName.equals((Object)Workspace.BASELINE_CONTROLLED_FOLDER_LIST)) {
            return this.getBaselineControlledFolderList(feedback);
        }
        if (propertyName.equals((Object)Workspace.CONTROLLABLE_RESOURCE_HOME)) {
            return this.getControllableResourceHome(feedback);
        }
        if (propertyName.equals((Object)Workspace.STREAM)) {
            return this.getStream(feedback);
        }
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY_LIST)) {
            ArrayList<CTActivity> result = new ArrayList<CTActivity>();
            CTActivity act = this.lookupCurrentActivity(feedback);
            if (act != null) {
                result.add(act);
            }
            return result;
        }
        if (propertyName.equals((Object)Workspace.CONFIGURATION)) {
            return this.lookupWorkspaceConfiguration(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public CTWvcmConfiguration lookupWorkspaceConfiguration(SrvcFeedback feedback) throws WvcmException {
        CTStream stream = this.getStream(feedback);
        CTComponent component = stream.lookupSingleCompositeInitialFoundationBaseline(null, feedback);
        CTWvcmConfiguration result = component == null ? null : CTWvcmConfiguration.valueOf(this, component, feedback);
        return result;
    }

    private CTControllableFolder getControllableResourceHome(SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        Collection<String> componentRootDirs = cc.getModifiableRootedComponents(this.getStreamSelector(feedback), this.getViewTag(), feedback).values();
        if (componentRootDirs.size() == 0) {
            return null;
        }
        CTLocation bcfLoc = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, componentRootDirs.iterator().next());
        return new CTControllableFolder((Location)bcfLoc, this.provider());
    }

    private Object getActivityFolderLocation(SrvcFeedback feedback) {
        CTProvider p = this.provider();
        Folder activityFolder = p.folder((Location)this.location());
        ResourceList result = p.resourceList((Resource[])new Folder[0]);
        result.add((Object)activityFolder);
        return result;
    }

    private List<CTControllableFolder> getBaselineControlledFolderList(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CCaseLib cc = p.getCCaseLib();
        String streamSelector = this.getStreamSelector(feedback);
        Collection<String> componentRootDirs = cc.getRootedComponents(streamSelector, this.getViewTag(), feedback).values();
        ArrayList<CTControllableFolder> result = new ArrayList<CTControllableFolder>(componentRootDirs.size());
        for (String componentRootDir : componentRootDirs) {
            CTLocation bcfLoc = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, componentRootDir);
            result.add(new CTControllableFolder((Location)bcfLoc, p));
        }
        return result;
    }

    @Override
    public synchronized String getStreamSelector(SrvcFeedback feedback) throws WvcmException {
        return this.provider().getCCaseLib().getStreamUniversalSelector(this.getViewTag(), feedback);
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY_LIST)) {
            String actName = "-none";
            List actList = (List)value;
            if (actList != null && actList.size() > 0) {
                actName = ((CTActivity)((Object)actList.get(0))).getActivityName(feedback);
            }
            CCaseLib cc = this.provider().getCCaseLib();
            String oldActivitySelector = cc.getCurrentActivity(this.getViewTag(), feedback);
            cc.setActivity(this.getViewTag(), actName, feedback);
            String newActivitySelector = null;
            if (!actName.equals("-none")) {
                newActivitySelector = cc.getCurrentActivity(this.getViewTag(), feedback);
            }
            if (oldActivitySelector != null && !oldActivitySelector.equals(newActivitySelector) && cc.isActivityOnCQEnabledProject(oldActivitySelector, feedback)) {
                cc.performCQActionOnUCMRecord(oldActivitySelector, feedback);
            }
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    public void doCheckinAll(String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        String viewTag = this.getViewTag();
        ArrayList<String> componentRoots = new ArrayList<String>(cc.getRootedComponents(this.getStreamSelector(feedback), viewTag, feedback).values());
        this.checkinAllHelper(comment, flags, componentRoots, viewTag, feedback);
    }

    public static CTUcmView doCreateGeneratedResource(CTProvider provider, Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        String streamSelector;
        CTLocation loc = (CTLocation)location;
        String cleanName = CCaseLib.cleanName(loc.getDisplayName());
        PropValue streamValue = updates != null ? updates.get(Workspace.TARGET) : null;
        boolean isolatedTarget = false;
        if (streamValue == null) {
            PropValue propValue = streamValue = updates != null ? updates.get(Workspace.ISOLATED_TARGET) : null;
            if (streamValue != null) {
                isolatedTarget = true;
            }
        }
        CTLocation streamLoc = streamValue != null ? (CTLocation)((Object)streamValue.get_value()) : null;
        String streamLocString = streamLoc != null ? streamLoc.getDisplayName() : null;
        CCaseLib cc = provider.getCCaseLib();
        CTStream stream = streamLocString == null ? null : (CTStream)provider.lookup((Location)CTLocation.valueOf(streamLocString), feedback);
        String string = streamSelector = stream == null ? null : stream.getSelector(feedback);
        if (isolatedTarget && streamSelector != null) {
            Map<String, String> rootedComponentNames2rootDirs = cc.getRootedComponents(streamSelector, null, feedback);
            Set<String> components = rootedComponentNames2rootDirs.keySet();
            if (components.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(NLS.bind((String)Messages.CTProvider_ERROR_NOTHING_IN_FOUNDATION, (Object)streamLocString));
                buffer.append(Messages.CTProvider_ERROR_UNABLE_TO_IMPORT_HISTORY);
                throw new WvcmException(buffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            ArrayList<String> foundBls = null;
            foundBls = new ArrayList<String>(components.size());
            for (String component : components) {
                String rootDir = rootedComponentNames2rootDirs.get(component);
                if ("<unavailable>".equals(rootDir)) {
                    feedback.notifyWarning(NLS.bind((String)Messages.CTUcmView_WARN_IGNORING_UNAVAIL_COMPONENT_WITH_NAME, (Object)component));
                    continue;
                }
                String baseline = cc.getInitialFoundationBaseline(streamSelector, component, feedback);
                if (baseline == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(NLS.bind((String)Messages.CTProvider_ERROR_NO_BASELINE_FOR_STREAM_COMPONENT, (Object)component, (Object)streamLocString));
                    buffer.append(Messages.CTProvider_ERROR_UNABLE_TO_IMPORT_HISTORY);
                    throw new WvcmException(buffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
                }
                foundBls.add(baseline);
            }
            String roStreamName = String.valueOf(ObjSelUtils.getObjSelName(streamSelector)) + "_READ_ONLY";
            try {
                streamSelector = cc.makeStream(streamSelector, false, true, foundBls, roStreamName, feedback);
            }
            catch (WvcmException e) {
                String parentProjectSel = cc.getProjectObjectSelector(streamSelector, feedback);
                if (cc.isSingleStreamProject(parentProjectSel, feedback)) {
                    String vobSelector = ObjSelUtils.getObjSelVobSel(streamSelector);
                    String projectName = PROJECT_PREFIX + ObjSelUtils.getObjSelName(streamSelector) + PROJECT_SUFFIX;
                    String projectSel = ObjSelUtils.formatSelector("project", projectName, vobSelector);
                    projectSel = cc.makeProject(projectSel, null, feedback);
                    String intStreamName = PROJECT_PREFIX + ObjSelUtils.getObjSelName(streamSelector) + STREAM_SUFFIX;
                    String intStreamSel = cc.makeStream(projectSel, true, foundBls, intStreamName, feedback);
                    streamSelector = cc.makeStream(intStreamSel, false, true, foundBls, roStreamName, feedback);
                }
                throw e;
            }
        }
        String viewTag = cc.makeView(cleanName, streamSelector, feedback);
        CTUcmView result = CTUcmView.valueOf(provider, viewTag);
        return result;
    }

    public static CTUcmView valueOf(CTProvider provider, String viewTag) throws WvcmException {
        CTLocation resultLoc = CTLocation.valueOf(CTLocation.Kind.WORKSPACE, viewTag);
        CTUcmView result = new CTUcmView((Location)resultLoc, provider);
        return result;
    }

    public <T extends SrvcResource> void doMerge(List<T> sourceLocations, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CCaseLib cc = p.getCCaseLib();
        for (SrvcResource o : sourceLocations) {
            if (o instanceof CTStream) {
                String wsStreamSel;
                CTStream source = (CTStream)o;
                String streamSel = source.location().getDisplayName();
                if (cc.equalObjSels(streamSel, wsStreamSel = this.getStreamSelector(feedback), feedback)) {
                    cc.syncToStreamConfiguration(this.getViewTag(), feedback);
                } else {
                    String wsStreamParentStreamSel = cc.getParentStream(wsStreamSel, feedback);
                    if (!cc.equalObjSels(wsStreamParentStreamSel, streamSel, feedback)) {
                        cc.deliverStream(streamSel, this.getViewTag(), flags, feedback);
                    }
                }
                this.flush(feedback);
                continue;
            }
            throw new IllegalArgumentException("doMerge() source is not a stream");
        }
    }

    public CTStream getStream(SrvcFeedback feedback) throws WvcmException {
        String streamSelector;
        CTLocation streamLoc;
        CTProvider p = this.provider();
        CTStream result = (CTStream)p.lookup((Location)(streamLoc = CTLocation.valueOf(CTLocation.Kind.STREAM, streamSelector = this.getStreamSelector(feedback))), feedback);
        if (result == null) {
            result = new CTStream((Location)streamLoc, p);
        }
        return result;
    }

    @Override
    public CTActivity lookupCurrentActivity(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        String activitySelector = p.getCCaseLib().getCurrentActivity(this.getViewTag(), feedback);
        if (activitySelector == null) {
            return null;
        }
        CTLocation activityLoc = CTLocation.valueOf(CTLocation.Kind.ACTIVITY, activitySelector);
        CTActivity result = (CTActivity)p.lookup((Location)activityLoc, feedback);
        if (result == null) {
            result = new CTActivity((Location)activityLoc, p);
        }
        return result;
    }

    @Override
    public void prepareToWrite(String pathname, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        String viewTag = this.getViewTag();
        cc.checkoutIgnoreExpectedFailures(viewTag, pathname, this.getStreamSelector(feedback), feedback);
    }

    public String getComponentPathname(CTLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo compInfo;
        CCaseLib cc = this.provider().getCCaseLib();
        String compSelector = componentLocation.getDisplayName();
        String result = cc.getComponentPathnameFromAnyKindOfName(this.getViewTag(), compSelector, feedback);
        if (!(result != null && result.length() != 0 || (compInfo = CCaseObjInfo.getObjInfo(cc, compSelector, feedback)).getMtype().equals("component"))) {
            String extendedName = cc.getExtendedName(this.getViewTag(), compSelector, feedback);
            throw new WvcmException(NLS.bind((String)Messages.CTUcmView_ERROR_INVALID_UCM_COMPONENT, (Object)extendedName), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    @Override
    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        if (sourceList != null && !sourceList.isEmpty()) {
            ArrayList<String> rebaseBaselines = new ArrayList<String>();
            for (SrvcResource source : sourceList) {
                String wsStreamSel;
                String streamSel;
                if (source instanceof CTBaseline) {
                    CTBaseline baseline = (CTBaseline)source;
                    rebaseBaselines.add(baseline.location().getDisplayName());
                    continue;
                }
                if (!(source instanceof CTStream) || !cc.equalObjSels(streamSel = ((CTStream)source).location().getDisplayName(), wsStreamSel = this.getStreamSelector(feedback), feedback)) continue;
                cc.syncToStreamConfiguration(this.getViewTag(), feedback);
            }
            if (!rebaseBaselines.isEmpty()) {
                String rebaseBls = CommonUtils.getCommaSeparatedFromList(rebaseBaselines);
                cc.rebaseStream(this.getViewTag(), this.getStreamSelector(feedback), rebaseBls, feedback);
            }
        }
    }

    @Override
    public void doCreateCompositeBaseline(CTLocation myLoc, String nameHint, ControllableResource.CheckinFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTLocation compLoc = myLoc.getContextLocation(CTLocation.Kind.COMPONENT);
        String compSel = compLoc.getDisplayName();
        this._latestCompositeBaseline = this.cc.makeBaseline(this.getViewTag(), compSel, nameHint, null, null, feedback);
    }

    @Override
    public CTBaseline getLatestCompositeBaseline(SrvcFeedback feedback) throws WvcmException {
        CTBaseline result = null;
        if (this._latestCompositeBaseline != null) {
            CTLocation resultLoc = CTLocation.valueOf(CTLocation.Kind.BASELINE, this._latestCompositeBaseline);
            result = (CTBaseline)this.provider().get((Location)resultLoc, feedback);
        }
        return result;
    }
}

