/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Commit;
import com.urbancode.air.vc.LatestVersionEntry;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.PersistentRecord;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.interceptors.InterceptorRegistry;
import com.urbancode.air.vc.interceptors.WriteInterceptor;
import com.urbancode.air.vc.metadata.RecordMetadata;
import com.urbancode.air.vc.metadata.RecordMetadataGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistentWriter {
    private final Repository repository;

    PersistentWriter(Repository repository) {
        this.repository = repository;
    }

    Map<Class<?>, List<Object>> write(Commit commit, Map<Persistent, String> persistents, long startCommit) {
        return this.savePersistentRecord(commit, persistents, startCommit, false);
    }

    <T extends Persistent> void runWriteInterceptors(T target) {
        List<WriteInterceptor> writeInterceptors = InterceptorRegistry.getInstance().getWriteInterceptors();
        for (WriteInterceptor interceptor : writeInterceptors) {
            interceptor.interceptWrite(target);
        }
    }

    Map<Class<?>, List<Object>> delete(Commit commit, Map<Persistent, String> persistents, long startCommit) {
        return this.savePersistentRecord(commit, persistents, startCommit, true);
    }

    private Map<Class<?>, List<Object>> savePersistentRecord(Commit commit, Map<Persistent, String> persistentsMap, long startCommit, boolean deleted) {
        HashMap returnMap = new HashMap();
        returnMap.put(PersistentRecord.class, new ArrayList());
        returnMap.put(RecordMetadata.class, new ArrayList());
        returnMap.put(LatestVersionEntry.class, new ArrayList());
        HashMap<String, LatestVersionEntry> latestEntries = new HashMap<String, LatestVersionEntry>();
        HashMap<String, Long> pathToLatestCommitMap = new HashMap<String, Long>();
        HashMap<String, Integer> pathToLatestVersionMap = new HashMap<String, Integer>();
        Set<Persistent> persistents = persistentsMap.keySet();
        List<String> persistentPaths = new ArrayList<String>();
        for (Persistent persistent : persistents) {
            persistentPaths.add(persistent.getPersistenceData().getPath());
        }
        Session session = this.repository.getTxManager().getSession();
        while (persistentPaths.size() > 0) {
            int split = Math.min(persistentPaths.size(), 500);
            List iterationPaths = persistentPaths.subList(0, split);
            persistentPaths = persistentPaths.subList(split, persistentPaths.size());
            Criteria latestVersionCriteria = session.createCriteria(LatestVersionEntry.class);
            latestVersionCriteria.add(Restrictions.in((String)"path", iterationPaths));
            for (Object rawLatestVersionEntry : latestVersionCriteria.list()) {
                LatestVersionEntry latestVersionEntry = (LatestVersionEntry)rawLatestVersionEntry;
                latestEntries.put(latestVersionEntry.getPath(), latestVersionEntry);
            }
            SQLQuery sqlQuery = session.createSQLQuery("select lve.path as path, pr.commit_id as commitId, pr.relative_version as relVersion from vc_latest_version_entry lve inner join vc_persistent_record pr on pr.id = lve.persistent_record_id where lve.path in :paths");
            sqlQuery.addScalar("path", (Type)new StringType());
            sqlQuery.addScalar("commitId", (Type)new LongType());
            sqlQuery.addScalar("relVersion", (Type)new IntegerType());
            sqlQuery.setParameterList("paths", iterationPaths);
            for (Object rawResult : sqlQuery.list()) {
                Object[] rawResultArray = (Object[])rawResult;
                String path = (String)rawResultArray[0];
                Long commitId = (Long)rawResultArray[1];
                Integer relVersion = (Integer)rawResultArray[2];
                pathToLatestCommitMap.put(path, commitId);
                pathToLatestVersionMap.put(path, relVersion);
            }
        }
        for (Persistent persistent : persistents) {
            PersistenceData persistenceData = persistent.getPersistenceData();
            String path = persistenceData.getPath();
            Long latestCommit = (Long)pathToLatestCommitMap.get(path);
            Integer latestVersion = (Integer)pathToLatestVersionMap.get(path);
            if (latestVersion == null) {
                latestVersion = 0;
            }
            if (latestCommit != null && latestCommit > startCommit) {
                throw new ConcurrentModificationException("Persistent " + path + " has been modified since the " + "start of this transaction.");
            }
            PersistentRecord persistentRecord = new PersistentRecord(path, commit, latestVersion + 1, persistentsMap.get(persistent), deleted);
            ((List)returnMap.get(PersistentRecord.class)).add(persistentRecord);
            for (RecordMetadataGenerator generator : this.repository.getConfiguration().getMetadataGenerators()) {
                Collection<RecordMetadata> metadata = generator.generateMetadata(persistentRecord, persistent);
                for (RecordMetadata metadatum : metadata) {
                    ((List)returnMap.get(RecordMetadata.class)).add(metadatum);
                }
            }
            LatestVersionEntry latestVersionEntry = (LatestVersionEntry)latestEntries.get(path);
            if (latestVersionEntry != null) {
                latestVersionEntry.setPersistentRecord(persistentRecord);
                latestVersionEntry.setRelativeVersion(persistentRecord.getRelativeVersion());
                latestVersionEntry.setDeleted(persistentRecord.isDeleted());
                latestVersionEntry.setCommitNumber(persistentRecord.getCommitNumber());
                latestVersionEntry.setDirectory(persistentRecord.getDirectory());
                continue;
            }
            ((List)returnMap.get(LatestVersionEntry.class)).add(new LatestVersionEntry(persistentRecord));
        }
        return returnMap;
    }
}

