/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.expression.variables.AbstractAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.expression.variables.Messages;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

public class CurrentMilestoneVariable
extends AbstractAttributeVariable<IIterationHandle> {
    public static final String VARIABLE_ID = "current milestone";
    private static final UUID NON_EXISTENT_ITERATION = UUID.valueOf((String)"_oRrzkBz7Ed2OxdGQnowKzg");
    private boolean fIsCaching;
    private Collection<IIterationHandle> fIntervals;

    public CurrentMilestoneVariable() {
        this(false);
    }

    public CurrentMilestoneVariable(boolean isCaching) {
        this.fIsCaching = isCaching;
    }

    @Override
    public Collection<IIterationHandle> evaluate(IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fIntervals == null || !this.fIsCaching) {
            ArrayList<IIterationHandle> iterations = new ArrayList<IIterationHandle>();
            IProjectArea projectArea = context.getAuditableCommon().resolveAuditable((IAuditableHandle)context.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, monitor);
            IDevelopmentLineHandle[] iDevelopmentLineHandleArray = projectArea.getDevelopmentLines();
            int n = iDevelopmentLineHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDevelopmentLineHandle developmentLine = iDevelopmentLineHandleArray[n2];
                IIterationHandle currentMilestone = IterationsHelper.findCurrentMilestone(context.getAuditableCommon(), developmentLine, monitor);
                if (currentMilestone != null) {
                    iterations.add(currentMilestone);
                }
                ++n2;
            }
            if (iterations.isEmpty()) {
                iterations.add((IIterationHandle)context.getAuditableCommon().createAuditableHandle(IIteration.ITEM_TYPE, NON_EXISTENT_ITERATION, null));
            }
            this.fIntervals = iterations;
        }
        return this.fIntervals;
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("CurrentMilestoneVariable.CURRENT_ITERATION");
    }

    @Override
    public String getId() {
        return VARIABLE_ID;
    }

    public boolean equals(Object obj) {
        return obj instanceof CurrentMilestoneVariable;
    }

    public int hashCode() {
        return VARIABLE_ID.hashCode();
    }
}

