/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.internal.PropertyUtil;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;

public class AuditableCache {
    private Map<Object, IItemTypeCache<?>> fItemTypeCaches = new HashMap();
    private ReadWriteLock fLock = new ReentrantReadWriteLock();

    public <T extends IAuditable> void cache(T auditable) {
        this.fLock.writeLock().lock();
        try {
            IItemTypeCache<T> itemTypeCache = this.getItemTypeCache(auditable.getItemType());
            if (itemTypeCache != null) {
                itemTypeCache.cache(auditable);
            }
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public <T extends IAuditable> void cacheAll(List<T> auditables, ItemProfile<T> profile) {
        this.fLock.writeLock().lock();
        try {
            IItemTypeCache<T> itemTypeCache = this.getItemTypeCache(profile.getItemType());
            if (itemTypeCache != null) {
                itemTypeCache.cacheAll(auditables, profile);
            }
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public <T extends IAuditable> List<T> getAll(ItemProfile<T> profile) {
        this.fLock.readLock().lock();
        try {
            IItemTypeCache<T> itemTypeCache = this.getItemTypeCache(profile.getItemType());
            if (itemTypeCache != null) {
                List<T> list = itemTypeCache.getAll(profile);
                return list;
            }
            return null;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public void addItemTypeCache(IItemType itemType, IItemTypeCache<?> typeCache) {
        this.fLock.writeLock().lock();
        try {
            typeCache.setLock(this.fLock);
            this.fItemTypeCaches.put(this.itemTypeKey(itemType), typeCache);
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    private <T extends IAuditable> IItemTypeCache<T> getItemTypeCache(IItemType itemType) {
        return this.fItemTypeCaches.get(this.itemTypeKey(itemType));
    }

    private Object itemTypeKey(IItemType itemType) {
        return String.valueOf(itemType.getNamespaceURI()) + "#" + itemType.getName();
    }

    public static interface IItemTypeCache<T extends IAuditable> {
        public void cache(T var1);

        public void cacheAll(List<T> var1, ItemProfile<T> var2);

        public List<T> getAll(ItemProfile<T> var1);

        public void setLock(ReadWriteLock var1);
    }

    public static class PrimitiveCache<T extends IAuditable>
    implements IItemTypeCache<T> {
        private static final int ITEM_TYPE_CACHE_SIZES = 500;
        private List<IAuditable> fCacheSequence = new ArrayList<IAuditable>();
        private Map<UUID, IAuditable> fCacheMap = new HashMap<UUID, IAuditable>();
        private int fCacheSize;
        private ItemProfile<? extends IAuditable> fCompleteProfile = null;
        private ReadWriteLock fLock;

        public PrimitiveCache() {
            this(500);
        }

        public PrimitiveCache(int cacheSize) {
            this.fCacheSize = cacheSize;
        }

        @Override
        public void cache(T auditable) {
            this.fLock.writeLock().lock();
            try {
                if (auditable.isWorkingCopy()) {
                    return;
                }
                IAuditable cache = this.fCacheMap.get(auditable.getItemId());
                if (cache == null) {
                    this.addEntry((IAuditable)auditable);
                    return;
                }
                this.fCacheSequence.remove(cache);
                boolean isCachedSmaller = PrimitiveCache.isGreaterOrEqual(auditable, cache);
                boolean updateCache = PrimitiveCache.isMoreRecent(auditable, cache) || !PrimitiveCache.isMoreRecent(cache, auditable) && isCachedSmaller;
                this.addEntry((IAuditable)(updateCache ? auditable : cache));
            }
            finally {
                this.fLock.writeLock().unlock();
            }
        }

        @Override
        public void cacheAll(List<T> auditables, ItemProfile<T> profile) {
            this.fLock.writeLock().lock();
            try {
                for (IAuditable auditable : auditables) {
                    if (auditable == null) continue;
                    Assert.isTrue((boolean)profile.isMatched(auditable));
                    this.cache(auditable);
                }
                if (auditables.size() <= this.fCacheSize && !this.isComplete(profile)) {
                    this.setIsComplete(profile);
                }
            }
            finally {
                this.fLock.writeLock().unlock();
            }
        }

        @Override
        public List<T> getAll(ItemProfile<T> profile) {
            this.fLock.readLock().lock();
            try {
                if (this.isComplete(profile)) {
                    ArrayList<IAuditable> result = new ArrayList<IAuditable>();
                    for (IAuditable cache : this.fCacheSequence) {
                        result.add(cache);
                    }
                    ArrayList<IAuditable> arrayList = result;
                    return arrayList;
                }
                return null;
            }
            finally {
                this.fLock.readLock().unlock();
            }
        }

        @Override
        public void setLock(ReadWriteLock lock) {
            this.fLock = lock;
        }

        private void addEntry(IAuditable add) {
            if (this.fCacheSequence.size() >= this.fCacheSize) {
                this.setIsComplete(null);
                int i = 0;
                while (i < 5) {
                    IAuditable remove = this.fCacheSequence.remove(0);
                    this.fCacheMap.remove(remove.getItemId());
                    ++i;
                }
            }
            if (this.invalidatesCompleteness(add)) {
                ItemProfile<IAuditable> profile = ItemProfile.computeProfile(add);
                ArrayList<String> properties = new ArrayList<String>();
                if (this.fCompleteProfile != null) {
                    properties.addAll(this.fCompleteProfile.getProperties());
                }
                Iterator iter = properties.iterator();
                while (iter.hasNext()) {
                    String property = (String)iter.next();
                    if (profile.contains(property)) continue;
                    iter.remove();
                }
                if (properties.isEmpty()) {
                    this.setIsComplete(null);
                } else {
                    this.setIsComplete(ItemProfile.createProfile(add.getItemType(), properties));
                }
            }
            this.fCacheSequence.add(add);
            this.fCacheMap.put(add.getItemId(), add);
        }

        private boolean invalidatesCompleteness(IAuditable auditable) {
            if (this.fCompleteProfile == null) {
                return false;
            }
            ItemProfile<IAuditable> profile = ItemProfile.computeProfile(auditable);
            return !profile.contains(this.fCompleteProfile);
        }

        private static boolean isMoreRecent(IAuditable add, IAuditable auditable) {
            Date update = add.modified();
            Date existing = auditable.modified();
            if (update != null && existing != null) {
                return update.after(existing);
            }
            return true;
        }

        private static boolean isGreaterOrEqual(IAuditable add, IAuditable auditable) {
            ItemProfile<IAuditable> update = ItemProfile.computeProfile(add);
            ItemProfile<IAuditable> existing = ItemProfile.computeProfile(auditable);
            if (update != null && existing != null) {
                return update.contains(existing);
            }
            return true;
        }

        private boolean isComplete(ItemProfile<? extends IAuditable> profile) {
            if (this.fCompleteProfile == null) {
                return false;
            }
            return this.fCompleteProfile.contains(profile);
        }

        private void setIsComplete(ItemProfile<? extends IAuditable> profile) {
            this.fCompleteProfile = profile;
        }
    }

    public static class ScopedItemTypeCache<T extends IAuditable>
    implements IItemTypeCache<T> {
        private static final int ITEM_TYPE_CACHE_SIZES = 500;
        private Map<UUID, IItemTypeCache<T>> fScopedCaches = new HashMap<UUID, IItemTypeCache<T>>();
        private boolean fAllScopedCaches = false;
        private IItemType fItemType;
        private String fScopeProperty;
        private ReadWriteLock fLock;
        private int fCacheSize;

        public ScopedItemTypeCache(IItemType itemType, String scopeProperty) {
            this(itemType, scopeProperty, 500);
        }

        public ScopedItemTypeCache(IItemType itemType, String scopeProperty, int cacheSize) {
            this.fItemType = itemType;
            this.fScopeProperty = scopeProperty;
            this.fCacheSize = cacheSize;
        }

        @Override
        public void cache(T auditable) {
            this.fLock.writeLock().lock();
            try {
                if (auditable != null && auditable.getItemType().equals(this.fItemType) && auditable.isPropertySet(this.fScopeProperty)) {
                    this.getCache(this.getScopeUUID(auditable)).cache(auditable);
                }
            }
            finally {
                this.fLock.writeLock().unlock();
            }
        }

        @Override
        public void cacheAll(List<T> auditables, ItemProfile<T> profile) {
            this.fLock.writeLock().lock();
            try {
                if (this.fItemType.equals(profile.getItemType()) && profile.contains(this.fScopeProperty)) {
                    HashMap<UUID, ArrayList<IAuditable>> map = new HashMap<UUID, ArrayList<IAuditable>>();
                    for (IAuditable iAuditable : auditables) {
                        Assert.isTrue((iAuditable != null && iAuditable.getItemType().equals(this.fItemType) && iAuditable.isPropertySet(this.fScopeProperty) ? 1 : 0) != 0);
                        UUID scope = this.getScopeUUID(iAuditable);
                        ArrayList<IAuditable> list = (ArrayList<IAuditable>)map.get(scope);
                        if (list == null) {
                            list = new ArrayList<IAuditable>();
                            map.put(scope, list);
                        }
                        list.add(iAuditable);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        this.getCache((UUID)entry.getKey()).cacheAll((List)entry.getValue(), profile);
                    }
                    this.fAllScopedCaches = true;
                }
            }
            finally {
                this.fLock.writeLock().unlock();
            }
        }

        @Override
        public List<T> getAll(ItemProfile<T> profile) {
            this.fLock.readLock().lock();
            try {
                if (!this.fAllScopedCaches || !profile.getItemType().equals(this.fItemType)) {
                    return null;
                }
                ArrayList<T> result = new ArrayList<T>();
                for (IItemTypeCache<T> cache : this.fScopedCaches.values()) {
                    List<T> all = cache.getAll(profile);
                    if (all == null) {
                        return null;
                    }
                    result.addAll(all);
                }
                ArrayList<T> arrayList = result;
                return arrayList;
            }
            finally {
                this.fLock.readLock().unlock();
            }
        }

        public void cacheAll(IAuditableHandle scope, List<T> auditables, ItemProfile<T> profile) {
            this.fLock.writeLock().lock();
            try {
                Assert.isTrue((boolean)profile.contains(this.fScopeProperty));
                for (IAuditable current : auditables) {
                    UUID currentScope = this.getScopeUUID(current);
                    Assert.isTrue((scope == null && currentScope == null || scope != null && scope.getItemId().equals((Object)currentScope) ? 1 : 0) != 0);
                }
                this.getCache(scope != null ? scope.getItemId() : null).cacheAll(auditables, profile);
            }
            finally {
                this.fLock.writeLock().unlock();
            }
        }

        public void invalidate(IAuditableHandle scope) {
            this.fLock.writeLock().lock();
            try {
                this.fScopedCaches.remove(scope != null ? scope.getItemId() : null);
            }
            finally {
                this.fLock.writeLock().unlock();
            }
        }

        public List<T> getAll(IAuditableHandle scope, ItemProfile<T> profile) {
            this.fLock.readLock().lock();
            try {
                List<T> list = this.getCache(scope != null ? scope.getItemId() : null).getAll(profile);
                return list;
            }
            finally {
                this.fLock.readLock().unlock();
            }
        }

        @Override
        public void setLock(ReadWriteLock lock) {
            this.fLock = lock;
        }

        private IItemTypeCache<T> getCache(UUID uuid) {
            IItemTypeCache<T> cache = this.fScopedCaches.get(uuid);
            if (cache == null) {
                cache = new PrimitiveCache(this.fCacheSize);
                cache.setLock(this.fLock);
                this.fScopedCaches.put(uuid, cache);
            }
            return cache;
        }

        private UUID getScopeUUID(T auditable) {
            IAuditableHandle handle = (IAuditableHandle)PropertyUtil.get(auditable, this.fScopeProperty);
            return handle != null ? handle.getItemId() : null;
        }
    }
}

