/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.CopyToProjectOperation;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.EMFHelper;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class SplitWorkItemOperation {
    private List<CopyToProjectOperation.CopyProblem> fCopyProblems = new ArrayList<CopyToProjectOperation.CopyProblem>();

    public void run(List<? extends IWorkItem> sourceWorkItems, IContributorHandle newOwner, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        for (IWorkItem iWorkItem : sourceWorkItems) {
            if (iWorkItem == null) continue;
            this.execute((WorkItem)iWorkItem, workItemCommon, newOwner, monitor != null ? new SubProgressMonitor(monitor, 1) : null);
        }
    }

    private void execute(WorkItem workItemOriginal, IWorkItemCommon workItemCommon, IContributorHandle newOwner, SubProgressMonitor subProgressMonitor) throws TeamRepositoryException {
        Identifier<IWorkflowAction> resolveAction;
        WorkflowManager workflowManager;
        IWorkflowInfo workflowInfo;
        Identifier<IResolution>[] resolutions;
        if (workItemOriginal.getTimeSpent() <= 0L) {
            this.fCopyProblems.add(new CopyToProjectOperation.CopyProblem(Messages.getString("SplitWorkItemOperation.MSG_SAVE_BEFORE_SPLIT_CHECK_TIMESPENT")));
            return;
        }
        IProjectAreaHandle projectArea = workItemOriginal.getProjectArea();
        String typeIdentifier = workItemOriginal.getWorkItemType();
        WorkItem workItemNew = (WorkItem)this.createWorkItem(projectArea, workItemCommon, typeIdentifier);
        workItemNew.setHTMLSummary(workItemOriginal.getHTMLSummary());
        workItemNew.setHTMLDescription(workItemOriginal.getHTMLDescription());
        workItemNew.setTarget(workItemOriginal.getTarget());
        workItemNew.setCategory(workItemOriginal.getCategory());
        if (workItemOriginal.getOwner() != null) {
            workItemNew.setOwner(workItemOriginal.getOwner());
        }
        workItemNew.setResolution2((resolutions = (workflowInfo = (workflowManager = (WorkflowManager)workItemCommon.getWorkflowManager()).getWorkflowInfo(workItemNew, (IProgressMonitor)subProgressMonitor)).getResolutionIds(resolveAction = workflowInfo.getResolveActionId())).length > 0 ? resolutions[0] : null);
        this.resetEstimatesForWorkItem(workItemOriginal, workItemNew);
        if (newOwner != null) {
            workItemOriginal.setOwner(newOwner);
        }
        IWorkItemReferences referencesOriginal = workItemCommon.resolveWorkItemReferences(workItemOriginal, (IProgressMonitor)subProgressMonitor);
        IWorkItemReferences referencesNew = workItemCommon.resolveWorkItemReferences(workItemNew, (IProgressMonitor)subProgressMonitor);
        for (IEndPointDescriptor endPoint : referencesOriginal.getTypes()) {
            if (endPoint == WorkItemEndPoints.PREDECESSOR_WORK_ITEMS) {
                for (IReference reference : referencesOriginal.getReferences(endPoint)) {
                    if (!"predecessor".equals(endPoint.getId())) continue;
                    referencesNew.add(endPoint, (IReference)EMFHelper.copy(reference));
                }
            }
            if (endPoint != WorkItemEndPoints.WORK_TIME) continue;
            for (IReference reference : referencesOriginal.getReferences(endPoint)) {
                if (!"timeSheetEntry".equals(endPoint.getId())) continue;
                referencesNew.add(endPoint, (IReference)EMFHelper.copy(reference));
                referencesOriginal.remove(reference);
            }
        }
        referencesNew.add(WorkItemEndPoints.COPIED_FROM_WORK_ITEM, (IReference)WorkItemLinkTypes.createWorkItemReference(workItemOriginal));
        this.save(workItemOriginal, referencesOriginal, workItemNew, referencesNew, workItemCommon, resolveAction, (IProgressMonitor)subProgressMonitor);
    }

    private void resetEstimatesForWorkItem(WorkItem workItemOriginal, WorkItem workItemNew) {
        if (!workItemOriginal.isSetTimeSpent()) {
            return;
        }
        long timeSpent = workItemOriginal.getTimeSpent();
        workItemNew.setDuration(workItemOriginal.getTimeSpent());
        workItemNew.setTimeSpent(workItemOriginal.getTimeSpent());
        long correctedEstimate = -1L;
        if (workItemOriginal.isSetCorrectedEstimate()) {
            correctedEstimate = workItemOriginal.getCorrectedEstimate();
        }
        long duration = -1L;
        if (workItemOriginal.isSetDuration()) {
            duration = workItemOriginal.getDuration();
        }
        if (correctedEstimate != -1L) {
            long difference = correctedEstimate - timeSpent;
            if (difference >= 0L) {
                workItemOriginal.setCorrectedEstimate(difference);
            } else {
                workItemOriginal.setCorrectedEstimate(0L);
            }
        } else if (duration != -1L) {
            long difference = duration - timeSpent;
            if (difference >= 0L) {
                workItemOriginal.setDuration(difference);
            } else {
                workItemOriginal.setDuration(0L);
            }
        }
        workItemOriginal.setTimeSpent(0L);
    }

    protected abstract void save(IWorkItem var1, IWorkItemReferences var2, IWorkItem var3, IWorkItemReferences var4, IWorkItemCommon var5, Identifier<IWorkflowAction> var6, IProgressMonitor var7) throws TeamRepositoryException;

    protected abstract IWorkItem createWorkItem(IProjectAreaHandle var1, IWorkItemCommon var2, String var3) throws TeamRepositoryException;

    public List<CopyToProjectOperation.CopyProblem> getCopyProblems() {
        return this.fCopyProblems;
    }

    public String getName() {
        return this.getName();
    }
}

