/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.expression;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.QueryableAttributeDescriptor;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ApprovalDescriptorAttributeDescriptor
extends QueryableAttributeDescriptor {
    private final EStructuralFeature fStructureFeature;

    public ApprovalDescriptorAttributeDescriptor(String identifier, String displayName, String type) {
        this(identifier, displayName, type, false, false);
    }

    public ApprovalDescriptorAttributeDescriptor(String identifier, String displayName, String type, boolean isSynthetic, boolean hasNullValue) {
        super(identifier, displayName, type, isSynthetic, hasNullValue);
        this.fStructureFeature = ModelPackage.eINSTANCE.getApprovalDescriptor().getEStructuralFeature(identifier);
        Assert.isNotNull((Object)this.fStructureFeature);
    }

    @Override
    public Object getValue(Object element, IEvaluationContext context, IProgressMonitor monitor) throws TeamRepositoryException {
        if (element instanceof IWorkItem) {
            IWorkItem workItem = (IWorkItem)element;
            List<IApprovalDescriptor> descriptors = workItem.getApprovals().getDescriptors();
            ArrayList<Object> elements = new ArrayList<Object>(descriptors.size());
            for (IApprovalDescriptor descriptor : descriptors) {
                elements.add(this.getProperty((EObject)descriptor));
            }
            return elements;
        }
        return super.getValue(element, context, monitor);
    }

    private Object getProperty(EObject descriptor) {
        return descriptor.eGet(this.fStructureFeature);
    }
}

