/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.query.ast.IDynamicQueryModel;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalState;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

public class ApprovalOperation
extends AttributeOperation {
    private final IApprovalState fApprovalState;

    public ApprovalOperation(String identifier, String name, IApprovalState approvalState) {
        super(identifier, name);
        this.fApprovalState = approvalState;
    }

    @Override
    public boolean evaluate(Object left, Object right, IEvaluationContext context, IProgressMonitor monitor) {
        if (left instanceof Collection) {
            for (Object leftItem : (Collection)left) {
                if (!(leftItem instanceof IApproval) || !this.evaluate((IApproval)leftItem, right)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evaluate(IApproval left, Object right) {
        if (this.fApprovalState != null && !left.getStateIdentifier().equals(this.fApprovalState.getIdentifier())) {
            return false;
        }
        if (right == null) {
            return true;
        }
        if (right instanceof Collection) {
            for (Object rightItem : (Collection)right) {
                if (rightItem instanceof IContributorHandle && left.getApprover().sameItemId((IItemHandle)((IContributorHandle)rightItem))) continue;
                return false;
            }
            return true;
        }
        return right instanceof IContributorHandle && left.getApprover().sameItemId((IItemHandle)((IContributorHandle)right));
    }

    @Override
    public IPredicate getPredicate(ITransformationContext context, IProgressMonitor monitor) {
        if (context.getAttribute().isStateExtension()) {
            throw new UnsupportedOperationException();
        }
        IDynamicQueryModel approvals = context.getReference(true);
        ISingleItemQueryModel approver = (ISingleItemQueryModel)approvals.getReference(ModelPackage.eINSTANCE.getApproval_Approver().getName());
        IStringField stateIdentifier = (IStringField)approvals.getField(ModelPackage.eINSTANCE.getApproval_StateIdentifier().getName());
        IPredicate predicate = null;
        if (context.getValue() == null) {
            predicate = approvals._isEmpty()._not();
        } else {
            predicate = approver._eq(context.getQuery().newItemHandleArg());
            context.addParameter(context.getValue());
        }
        if (this.fApprovalState != null) {
            IPredicate statePredicate = stateIdentifier._eq((IString)context.getQuery().newStringArg());
            context.addParameter(this.fApprovalState.getIdentifier());
            predicate = predicate._and(statePredicate);
        }
        return predicate;
    }
}

