/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.UriUtil;
import com.ibm.team.workitem.api.common.PLEConstants;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeRegistry;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeTypeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.LinkAttributeDescriptor;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Arrays;
import java.util.List;

public class ConfigurationManagementUtil {
    private static List<String> CONFIG_MANAGEMENT_LINK_TYPES = Arrays.asList(PLEConstants.PLE_WORKITEM_LINK_TYPES);

    public static IAttribute getMappedAttribute(String mappedAttributeId, IWorkItem workItem, IWorkItemCommon workItemCommon) throws TeamRepositoryException {
        if (mappedAttributeId != null) {
            IAttribute mappedAttribute;
            if (mappedAttributeId.equals("com.ibm.team.workitem.ple.derivedFromPlannedFor")) {
                mappedAttributeId = "target";
            }
            if ((mappedAttribute = workItemCommon.findAttribute(workItem.getProjectArea(), mappedAttributeId, null)) != null) {
                return mappedAttribute;
            }
        }
        return null;
    }

    public static IDeliverableHandle getMappedAttributeValue(IAttribute mappedAttribute, IWorkItem workitem, IWorkItemCommon workItemCommon) throws TeamRepositoryException {
        if (mappedAttribute != null && workitem.hasAttribute(mappedAttribute)) {
            Object attributeValue = workitem.getValue(mappedAttribute);
            if (mappedAttribute != null) {
                if (attributeValue instanceof IDeliverableHandle) {
                    return (IDeliverableHandle)attributeValue;
                }
                if (attributeValue instanceof IIterationHandle) {
                    return IterationsHelper.resolveDeliverableFromIteration(workitem.getProjectArea(), (IIterationHandle)attributeValue, workItemCommon, null);
                }
            }
        }
        return null;
    }

    public static String removeConfigurationURIParameter(String uri) {
        if (uri == null) {
            return null;
        }
        int configParmIndex = uri.indexOf("oslc_config.context");
        if (configParmIndex > 0) {
            return uri.substring(0, configParmIndex - 1);
        }
        return uri;
    }

    public static boolean isVersionableLinkType(String linkTypeId) {
        return CONFIG_MANAGEMENT_LINK_TYPES.contains(linkTypeId);
    }

    public static String appendConfigurationURIParameter(String baseURI, String configurationURI) {
        String resultURI = baseURI;
        if (configurationURI != null && configurationURI.length() > 0) {
            char parmSeparatorChar = resultURI.indexOf("?") == -1 ? (char)'?' : '&';
            resultURI = String.valueOf(resultURI) + parmSeparatorChar;
            resultURI = String.valueOf(resultURI) + "oslc_config.context=" + UriUtil.encode((String)configurationURI);
        }
        return resultURI;
    }

    public static void appendConfigurationURIParameter(StringBuilder gcAwareURI, String configurationURI) {
        if (configurationURI != null && configurationURI.length() > 0) {
            gcAwareURI.append(gcAwareURI.indexOf("?") == -1 ? "?" : "&");
            gcAwareURI.append("oslc_config.context=" + UriUtil.encode((String)configurationURI));
        }
    }

    public static boolean containsConfigurationURI(String uri) {
        return uri.toString().indexOf("oslc_config.context") > -1;
    }

    public static String getLinkTypeId(String oslcLinkType) {
        oslcLinkType = oslcLinkType.replaceFirst("oslc_cm:", "http://open-services.net/ns/cm#");
        IAttributeTypeDescriptor typeDescriptor = AttributeRegistry.getInstance().getTypeDescriptor("workItem");
        for (IAttributeDescriptor attrDescriptor : typeDescriptor.getAttributeDescriptors()) {
            Property linkProperty;
            if (!(attrDescriptor instanceof LinkAttributeDescriptor) || (linkProperty = attrDescriptor.getProperty(OSLCCoreIdentifiers.VERSION_OSLC_CORE_20)) == null || !linkProperty.toString().equals(oslcLinkType)) continue;
            IEndPointDescriptor endpoint = ((LinkAttributeDescriptor)attrDescriptor).getEndPointDescriptor();
            return endpoint.getLinkType().getLinkTypeId();
        }
        return null;
    }
}

