/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.util.FileSize;
import com.ibm.team.workitem.common.internal.util.Messages;
import java.text.ChoiceFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;

public class FileSizeFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private static final String BUNDLE_BASE_NAME = FileSizeFormat.class.getName();
    private static final FieldPosition DONT_CARE = new FieldPosition(0);
    private static final String FORMAT_BYTES = "byteFormat";
    private static final String FORMAT_KBYTES = "kbyteFormat";
    private static final String FORMAT_MBYTES = "mbyteFormat";
    private static final String FORMAT_GBYTES = "gbyteFormat";
    private static final long KBYTES = 1024L;
    private static final long MBYTES = 0x100000L;
    private static final long GBYTES = 0x40000000L;
    private final Locale fLocale;
    private final Style fFormatStyle;
    private ResourceBundle fBundle;
    private List<Pattern> fPatterns;
    private NumberFormat fNumberFormat;
    private String fInvalidString;
    private String fUnspecifiedString;

    public static synchronized FileSizeFormat getInstance() {
        return FileSizeFormat.getInstance(Locale.getDefault());
    }

    public static synchronized FileSizeFormat getInstance(Style style) {
        return FileSizeFormat.getInstance(Locale.getDefault(), style);
    }

    public static synchronized FileSizeFormat getInstance(Locale locale) {
        Assert.isNotNull((Object)locale);
        return FileSizeFormat.getInstance(locale, Style.MEDIUM);
    }

    public static synchronized FileSizeFormat getInstance(Locale locale, Style style) {
        Assert.isNotNull((Object)locale);
        Assert.isNotNull((Object)((Object)style));
        return new FileSizeFormat(locale, style);
    }

    private FileSizeFormat(Locale locale, Style style) {
        this.fLocale = locale;
        this.fFormatStyle = style;
        this.fInvalidString = Messages.getString("FileSizeFormat.INVALID_DEFAULT");
        this.fUnspecifiedString = "";
    }

    public String format(FileSize fileSize) {
        return this.format(fileSize, new StringBuffer()).toString();
    }

    public StringBuffer format(FileSize fileSize, StringBuffer buffer) {
        return this.format(fileSize, buffer, DONT_CARE);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Assert.isLegal((boolean)(obj instanceof FileSize));
        FileSize fileSize = (FileSize)obj;
        if (!fileSize.isValid()) {
            toAppendTo.append(this.fInvalidString);
            return toAppendTo;
        }
        if (!fileSize.isSpecified()) {
            toAppendTo.append(this.fUnspecifiedString);
            return toAppendTo;
        }
        String pattern = this.getMatchingPattern(fileSize);
        Double units = this.getUnits(fileSize);
        ChoiceFormat choiceFormat = new ChoiceFormat(pattern);
        StringBuffer choice = choiceFormat.format(units, new StringBuffer(), DONT_CARE);
        MessageFormat format = new MessageFormat(choice.toString(), this.fLocale);
        return format.format(new Object[]{units}, toAppendTo, pos);
    }

    public FileSize parse(String string) throws ParseException {
        Assert.isNotNull((Object)string);
        ParsePosition position = new ParsePosition(0);
        FileSize size = (FileSize)this.parseObject(string, position);
        if (!size.isValid()) {
            String example = this.format(new FileSize(5120L));
            throw new ParseException(NLS.bind((String)Messages.getString("FileSizeFormat.NOT_VALID_EXAMPLE"), (Object)string, (Object[])new Object[]{example}), position.getErrorIndex());
        }
        return size;
    }

    @Override
    public Object parseObject(String source, ParsePosition position) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)position);
        int originalIndex = position.getIndex();
        List<Pattern> patterns = this.getPatterns();
        for (Pattern pattern : patterns) {
            position.setIndex(originalIndex);
            position.setErrorIndex(-1);
            if (!source.regionMatches(true, position.getIndex(), pattern.left, 0, pattern.left.length())) {
                position.setErrorIndex(position.getIndex());
                continue;
            }
            position.setIndex(position.getIndex() + pattern.left.length());
            this.skipWhiteSpace(source, position);
            Number number = this.getNumberFormat().parse(source, position);
            if (position.getErrorIndex() > -1) continue;
            this.skipWhiteSpace(source, position);
            if (!source.regionMatches(true, position.getIndex(), pattern.right, 0, pattern.right.length())) {
                position.setErrorIndex(position.getIndex());
                continue;
            }
            position.setIndex(position.getIndex() + pattern.right.length());
            this.skipWhiteSpace(source, position);
            if (position.getIndex() < source.length()) continue;
            return new FileSize(this.computeBytes(pattern.originKey, number));
        }
        return FileSize.INVALID;
    }

    private void skipWhiteSpace(String source, ParsePosition position) {
        int index = position.getIndex();
        while (index < source.length() && Character.isWhitespace(source.charAt(index))) {
            ++index;
        }
        position.setIndex(index);
    }

    private List<Pattern> getPatterns() {
        if (this.fPatterns == null) {
            HashMap<String, String> patternSet = new HashMap<String, String>();
            Enumeration<String> keys = this.getResourceBundle().getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String formatPattern = this.getResourceBundle().getString(key);
                StringTokenizer tokenizer = new StringTokenizer(formatPattern, "|");
                while (tokenizer.hasMoreTokens()) {
                    String format = tokenizer.nextToken().trim().substring(2);
                    patternSet.put(format, key);
                }
            }
            this.fPatterns = this.createPatterns(patternSet);
        }
        return this.fPatterns;
    }

    private List<Pattern> createPatterns(Map<String, String> patternSet) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(patternSet.size());
        for (String patternString : patternSet.keySet()) {
            int numberPosition = patternString.indexOf("{0}");
            if (numberPosition == -1) {
                throw new IllegalArgumentException(Messages.getString("FileSizeFormat.PATTERN_MUST_CONTAIN_PLACEHOLDER"));
            }
            Pattern pattern = new Pattern();
            pattern.left = patternString.substring(0, numberPosition).trim();
            pattern.right = patternString.substring(numberPosition + 3).trim();
            pattern.originKey = patternSet.get(patternString);
            patterns.add(pattern);
        }
        return patterns;
    }

    private long computeBytes(String key, Number number) {
        if (key.startsWith(FORMAT_BYTES)) {
            return number.longValue();
        }
        if (key.startsWith(FORMAT_KBYTES)) {
            return (long)(number.doubleValue() * 1024.0);
        }
        if (key.startsWith(FORMAT_MBYTES)) {
            return (long)(number.doubleValue() * 1048576.0);
        }
        if (key.startsWith(FORMAT_GBYTES)) {
            return (long)(number.doubleValue() * 1.073741824E9);
        }
        return FileSize.INVALID.longValue();
    }

    private double getUnits(FileSize fileSize) {
        double bytes = fileSize.longValue();
        if (bytes >= 1.073741824E9) {
            return bytes / 1.073741824E9;
        }
        if (bytes >= 1048576.0) {
            return bytes / 1048576.0;
        }
        if (bytes >= 1024.0) {
            return bytes / 1024.0;
        }
        return bytes;
    }

    private String getMatchingPattern(FileSize fileSize) {
        return this.getResourceBundle().getString(this.getPatternKey(fileSize));
    }

    private ResourceBundle getResourceBundle() {
        if (this.fBundle == null) {
            this.fBundle = ResourceBundle.getBundle(BUNDLE_BASE_NAME, this.fLocale);
            if (this.fBundle == null) {
                this.fBundle = ResourceBundle.getBundle(BUNDLE_BASE_NAME, Locale.US);
            }
        }
        return this.fBundle;
    }

    private String getPatternKey(FileSize fileSize) {
        long bytes = fileSize.longValue();
        if (bytes < 1024L) {
            return this.createIdentifier(FORMAT_BYTES);
        }
        if (bytes < 0x100000L) {
            return this.createIdentifier(FORMAT_KBYTES);
        }
        if (bytes < 0x40000000L) {
            return this.createIdentifier(FORMAT_MBYTES);
        }
        return this.createIdentifier(FORMAT_GBYTES);
    }

    private String createIdentifier(String formatBytes) {
        return String.valueOf(formatBytes) + this.fFormatStyle.getKey();
    }

    private NumberFormat getNumberFormat() {
        if (this.fNumberFormat == null) {
            this.fNumberFormat = NumberFormat.getInstance(this.fLocale);
        }
        return this.fNumberFormat;
    }

    public void setInvalidString(String invalid) {
        Assert.isNotNull((Object)invalid);
        this.fInvalidString = invalid;
    }

    public void setUnspecifiedString(String unspecified) {
        Assert.isNotNull((Object)unspecified);
        this.fUnspecifiedString = unspecified;
    }

    private static class Pattern {
        String left;
        String right;
        String originKey;

        private Pattern() {
        }
    }

    public static enum Style {
        EXTRA_LONG("XL"),
        LONG("L"),
        MEDIUM("M"),
        SHORT("S");

        private String fKey;

        private Style(String key) {
            this.fKey = key;
        }

        private String getKey() {
            return this.fKey;
        }
    }
}

