/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider2;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class AttributeType {
    private String fIdentifier;
    private AttributeOperation[] fOperations;
    private String[] fVariableIdentifiers;
    private Class<?> fInstanceType;
    private String fDefaultFullTextKind;

    public AttributeType(String identifier, Class<?> instanceType, AttributeOperation[] operations) {
        this(identifier, instanceType, operations, new String[0], "");
    }

    public AttributeType(String identifier, Class<?> instanceType, AttributeOperation[] operations, String[] variableIdentifiers, String defaultFullTextKind) {
        this.fIdentifier = identifier;
        this.fOperations = operations;
        this.fInstanceType = instanceType;
        this.fVariableIdentifiers = variableIdentifiers;
        this.fDefaultFullTextKind = defaultFullTextKind;
    }

    public String getIdentifier() {
        return this.fIdentifier;
    }

    public AttributeOperation[] getOperations() {
        return this.fOperations;
    }

    public String[] getVariables() {
        return this.fVariableIdentifiers;
    }

    public Class getInstanceType() {
        return this.fInstanceType;
    }

    public Object getNullValue(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    public Object getNullValue(IAuditableCommon auditableCommon, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getNullValue(auditableCommon, monitor);
    }

    public Object getDefaultValue(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getNullValue(auditableCommon, attribute, monitor);
    }

    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getValueSet(auditableCommon, workItem, attribute, monitor);
    }

    public List<Object> getValueSet(IValueSetProvider2.ValueSetProviderInput input, IProgressMonitor monitor) throws TeamRepositoryException {
        Object[] valueSet = this.getValueSet(input.getAuditableCommon(), input.getWorkItem(), input.getAttribute(), input.includeArchivedValues(), monitor);
        return valueSet != null ? Arrays.asList(valueSet) : Collections.emptyList();
    }

    public boolean hasValueSet() {
        return false;
    }

    public Object valueOf(String stringValue, Object origin) {
        try {
            Constructor<?> ctor = this.fInstanceType.getConstructor(String.class);
            return ctor.newInstance(stringValue);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot reconstruct value: " + stringValue);
        }
    }

    public String toString(Object value) {
        return value.toString();
    }

    public String getDefaultFullTextKind() {
        return this.fDefaultFullTextKind;
    }

    public Object getNullValue(IAuditableCommon auditableCommon) throws TeamRepositoryException {
        return this.getNullValue(auditableCommon, null);
    }
}

