/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.urelease.plugin.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkClassLoader {
    private static final Class[] parameters = new Class[]{URL.class};

    public static void addAllFiles(String path, String[] exclude) throws IOException {
        for (String fileName : BulkClassLoader.getListAllFiles(BulkClassLoader.sanitizePath(path))) {
            boolean isExcluded = false;
            if (exclude != null) {
                for (String s : exclude) {
                    if (!fileName.startsWith(s)) continue;
                    isExcluded = true;
                    break;
                }
            }
            if (isExcluded) continue;
            File f = new File(path + "/" + fileName);
            BulkClassLoader.addFile(f);
        }
    }

    public static List<String> getListAllFiles(String path) {
        File[] files;
        ArrayList<String> results = new ArrayList<String>();
        for (File file : files = new File(path).listFiles()) {
            if (!file.isFile()) continue;
            results.add(file.getName());
        }
        return results;
    }

    public static void addFile(String s) throws IOException {
        File f = new File(s);
        BulkClassLoader.addFile(f);
    }

    public static void addFile(File f) throws IOException {
        BulkClassLoader.addURL(f.toURL());
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static String sanitizePath(String path) throws IOException {
        return path.replace("%20", " ");
    }
}

