/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.util;

import com.ibm.team.repository.client.internal.TeamPlatformConstants;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.ThreadCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;

public class EventSource
implements IEventSource {
    private final EventSource parent;
    private final ReentrantLock publicLock;
    private final Object privateLock;
    private final Map genericListeners;
    private final Map typedListeners;
    private final LinkedList pendingEvents;
    private final BackgroundEventDispatcher backgroundEventDispatcher;

    public EventSource() {
        this(null);
    }

    public EventSource(EventSource parent) {
        this.parent = parent;
        this.publicLock = new ReentrantLock();
        this.privateLock = new Object();
        this.genericListeners = new HashMap();
        this.typedListeners = new HashMap();
        this.pendingEvents = new LinkedList();
        this.backgroundEventDispatcher = new BackgroundEventDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addGenericListener(Object category, IListener listener) {
        if (category == null) {
            throw new IllegalArgumentException("null event categories not allowed");
        }
        if (listener == null) {
            throw new IllegalArgumentException("null listeners not allowed");
        }
        Object object = this.privateLock;
        synchronized (object) {
            IdentityHashMap<IListener, IListener> listeners = (IdentityHashMap<IListener, IListener>)this.genericListeners.get(category);
            if (listeners == null) {
                listeners = new IdentityHashMap<IListener, IListener>();
                this.genericListeners.put(category, listeners);
            }
            if (!listeners.containsKey(listener)) {
                listeners.put(listener, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeGenericListener(Object category, IListener listener) {
        if (category == null) {
            throw new IllegalArgumentException("null event categories not allowed");
        }
        if (listener == null) {
            throw new IllegalArgumentException("null listeners not allowed");
        }
        Object object = this.privateLock;
        synchronized (object) {
            Map listeners = (Map)this.genericListeners.get(category);
            if (listeners != null && listeners.containsKey(listener)) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.genericListeners.remove(category);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void purgeGenericListener(IListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listeners not allowed");
        }
        Object object = this.privateLock;
        synchronized (object) {
            Iterator i = this.genericListeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Map listeners = (Map)entry.getValue();
                listeners.remove(listener);
                if (!listeners.isEmpty()) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTypedListener(Object category, Object listener) {
        if (category == null) {
            throw new IllegalArgumentException("null event categories not allowed");
        }
        if (listener == null) {
            throw new IllegalArgumentException("null listeners not allowed");
        }
        Object object = this.privateLock;
        synchronized (object) {
            IdentityHashMap<Object, Object> listeners = (IdentityHashMap<Object, Object>)this.typedListeners.get(category);
            if (listeners == null) {
                listeners = new IdentityHashMap<Object, Object>();
                this.typedListeners.put(category, listeners);
            }
            if (!listeners.containsKey(listener)) {
                listeners.put(listener, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTypedListener(Object category, Object listener) {
        if (category == null) {
            throw new IllegalArgumentException("null event categories not allowed");
        }
        if (listener == null) {
            throw new IllegalArgumentException("null listeners not allowed");
        }
        Object object = this.privateLock;
        synchronized (object) {
            Map listeners = (Map)this.typedListeners.get(category);
            if (listeners != null && listeners.containsKey(listener)) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.typedListeners.remove(category);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void purgeTypedListener(Object listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null listeners not allowed");
        }
        Object object = this.privateLock;
        synchronized (object) {
            Iterator i = this.typedListeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Map listeners = (Map)entry.getValue();
                listeners.remove(listener);
                if (!listeners.isEmpty()) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void queueEvent(Object event) {
        if (event == null) {
            throw new IllegalArgumentException("null events not allowed");
        }
        try {
            this.acquire();
            Object object = this.privateLock;
            synchronized (object) {
                this.pendingEvents.addLast(event);
            }
        }
        finally {
            this.release();
        }
    }

    public final void acquire() {
        this.publicLock.lock();
    }

    public final void release() {
        try {
            if (this.publicLock.getHoldCount() == 1) {
                this.sendEvents();
            }
        }
        finally {
            this.publicLock.unlock();
        }
    }

    protected List getCategoriesForEvent(Object event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException("Event sources with events not of type IEvent must implement getCategoriesForEvent");
    }

    protected void dispatchEvents(Object typedListener, List events) {
        if (typedListener == null) {
            throw new IllegalArgumentException();
        }
        if (events == null) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException("Event sources with typed listeners must implement dispatchEvents");
    }

    public final boolean internalIsBusy() {
        return this.backgroundEventDispatcher.isBusy();
    }

    protected final EventSource getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasGenericListeners() {
        Object object = this.privateLock;
        synchronized (object) {
            return !this.genericListeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasGenericListeners(Object category) {
        Object object = this.privateLock;
        synchronized (object) {
            Map listeners = (Map)this.genericListeners.get(category);
            return listeners != null && !listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Collection getGenericListeners(Object category) {
        Object object = this.privateLock;
        synchronized (object) {
            Map listeners = (Map)this.genericListeners.get(category);
            if (listeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(new ArrayList(listeners.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasTypedListeners() {
        Object object = this.privateLock;
        synchronized (object) {
            return !this.typedListeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasTypedListeners(Object category) {
        Object object = this.privateLock;
        synchronized (object) {
            Map listeners = (Map)this.typedListeners.get(category);
            return listeners != null && !listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Collection getTypedListeners(Object category) {
        Object object = this.privateLock;
        synchronized (object) {
            Map listeners = (Map)this.typedListeners.get(category);
            if (listeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(new ArrayList(listeners.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvents() {
        DispatcherEvents dispatcherEvents = null;
        Object object = this.privateLock;
        synchronized (object) {
            while (!this.pendingEvents.isEmpty()) {
                IdentityHashMap visited;
                final Object event = this.pendingEvents.removeFirst();
                final Collection[] eventCategories = new Collection[1];
                if (event instanceof IEvent) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                        }

                        public void run() throws Exception {
                            eventCategories[0] = ((IEvent)event).getCategories();
                            if (eventCategories[0] == null) {
                                throw new IllegalStateException();
                            }
                        }
                    });
                    if (eventCategories[0] == null) continue;
                    visited = new IdentityHashMap();
                    EventSource eventSource = this;
                    while (eventSource != null) {
                        for (Object category : eventCategories[0]) {
                            Collection listeners = eventSource.getGenericListeners(category);
                            for (Object listener : listeners) {
                                if (visited.containsKey(listener)) continue;
                                visited.put(listener, listener);
                                if (dispatcherEvents == null) {
                                    dispatcherEvents = new DispatcherEvents(this);
                                }
                                dispatcherEvents.queueEventForGenericListener((IListener)listener, (IEvent)event);
                            }
                        }
                        eventSource = eventSource.getParent();
                    }
                } else {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                        }

                        public void run() throws Exception {
                            eventCategories[0] = EventSource.this.getCategoriesForEvent(event);
                            if (eventCategories[0] == null) {
                                throw new IllegalStateException();
                            }
                        }
                    });
                    if (eventCategories[0] == null) continue;
                }
                visited = new IdentityHashMap();
                for (Object category : eventCategories[0]) {
                    Collection listeners = this.getTypedListeners(category);
                    for (Object listener : listeners) {
                        if (visited.containsKey(listener)) continue;
                        visited.put(listener, listener);
                        if (dispatcherEvents == null) {
                            dispatcherEvents = new DispatcherEvents(this);
                        }
                        dispatcherEvents.queueEventForTypedListener(listener, event);
                    }
                }
            }
        }
        if (dispatcherEvents != null) {
            this.backgroundEventDispatcher.queue(dispatcherEvents);
        }
    }

    private static class BackgroundEventDispatcher {
        private Log LOG = LogFactory.getLog(BackgroundEventDispatcher.class);
        private LinkedList<Object> awaitingProcessing;

        public void process(Object element) {
            Map typedListenerEvents;
            this.LOG.debug((Object)("Entering process with element: " + element.toString()));
            final DispatcherEvents dispatcherEvents = (DispatcherEvents)element;
            Map genericListenerEvents = dispatcherEvents.getGenericListenerEvents();
            if (genericListenerEvents != null) {
                for (Map.Entry entry : genericListenerEvents.entrySet()) {
                    final IListener listener = (IListener)entry.getKey();
                    final List events = (List)entry.getValue();
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            BackgroundEventDispatcher.this.LOG.error((Object)"Exception occured in process", exception);
                        }

                        public void run() throws Exception {
                            BackgroundEventDispatcher.this.LOG.debug((Object)"handling events");
                            listener.handleEvents(events);
                        }
                    });
                }
            }
            if ((typedListenerEvents = dispatcherEvents.getTypedListenerEvents()) != null) {
                for (Map.Entry entry : typedListenerEvents.entrySet()) {
                    final Object listener = entry.getKey();
                    final List events = (List)entry.getValue();
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            BackgroundEventDispatcher.this.LOG.error((Object)"Exception occured in process", exception);
                        }

                        public void run() throws Exception {
                            BackgroundEventDispatcher.this.LOG.debug((Object)"dispatching events");
                            dispatcherEvents.getEventSource().dispatchEvents(listener, events);
                        }
                    });
                }
            }
        }

        public synchronized boolean isBusy() {
            boolean isBusy = this.awaitingProcessing != null && !this.awaitingProcessing.isEmpty();
            this.LOG.debug((Object)("isBusy: " + isBusy));
            return isBusy;
        }

        protected void process() {
            this.LOG.debug((Object)"Entering process");
            ThreadCheck.runProhibitingLongOps(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Object element;
                        BackgroundEventDispatcher backgroundEventDispatcher = BackgroundEventDispatcher.this;
                        synchronized (backgroundEventDispatcher) {
                            if (BackgroundEventDispatcher.this.awaitingProcessing.isEmpty()) {
                                BackgroundEventDispatcher.this.LOG.debug((Object)"Processing complete");
                                BackgroundEventDispatcher.this.awaitingProcessing = null;
                                return;
                            }
                            element = BackgroundEventDispatcher.this.awaitingProcessing.getFirst();
                        }
                        BackgroundEventDispatcher.this.process(element);
                        backgroundEventDispatcher = BackgroundEventDispatcher.this;
                        synchronized (backgroundEventDispatcher) {
                            BackgroundEventDispatcher.this.awaitingProcessing.removeFirst();
                        }
                    }
                }
            });
        }

        public synchronized void queue(Object element) {
            this.LOG.debug((Object)("Queuing element: " + element.toString()));
            if (this.awaitingProcessing == null) {
                this.LOG.debug((Object)"Processing queue null, creating new list");
                this.awaitingProcessing = new LinkedList();
                this.logTPEInformation();
                if (!TeamPlatformConstants.getEventSourceTPE().isShutdown()) {
                    TeamPlatformConstants.getEventSourceTPE().execute(new Runnable(){

                        @Override
                        public void run() {
                            BackgroundEventDispatcher.this.LOG.debug((Object)"Beginning execution.");
                            BackgroundEventDispatcher.this.process();
                        }
                    });
                }
            }
            this.awaitingProcessing.add(element);
        }

        public synchronized void logTPEInformation() {
            this.LOG.debug((Object)"ThreadPoolExecutor information:");
            this.LOG.debug((Object)("Is Shut Down? " + TeamPlatformConstants.getEventSourceTPE().isShutdown()));
            this.LOG.debug((Object)("Active threads: " + TeamPlatformConstants.getEventSourceTPE().getActiveCount()));
            this.LOG.debug((Object)("Maximum pool size: " + TeamPlatformConstants.getEventSourceTPE().getMaximumPoolSize()));
            this.LOG.debug((Object)("Current pool size:" + TeamPlatformConstants.getEventSourceTPE().getPoolSize()));
            this.LOG.debug((Object)("Current core pool size: " + TeamPlatformConstants.getEventSourceTPE().getCorePoolSize()));
            this.LOG.debug((Object)("Lifetime tasks scheduled: " + TeamPlatformConstants.getEventSourceTPE().getTaskCount()));
            this.LOG.debug((Object)("Lifetime tasks completed: " + TeamPlatformConstants.getEventSourceTPE().getCompletedTaskCount()));
        }
    }

    private static class DispatcherEvents {
        private final EventSource eventSource;
        private Map genericListenerEvents = null;
        private Map typedListenerEvents = null;

        public DispatcherEvents(EventSource eventSource) {
            this.eventSource = eventSource;
        }

        public EventSource getEventSource() {
            return this.eventSource;
        }

        public void queueEventForGenericListener(IListener listener, IEvent event) {
            LinkedList<IEvent> events;
            if (this.genericListenerEvents == null) {
                this.genericListenerEvents = new IdentityHashMap();
            }
            if ((events = (LinkedList<IEvent>)this.genericListenerEvents.get(listener)) == null) {
                events = new LinkedList<IEvent>();
                this.genericListenerEvents.put(listener, events);
            }
            events.add(event);
        }

        public void queueEventForTypedListener(Object listener, Object event) {
            LinkedList<Object> events;
            if (this.typedListenerEvents == null) {
                this.typedListenerEvents = new IdentityHashMap();
            }
            if ((events = (LinkedList<Object>)this.typedListenerEvents.get(listener)) == null) {
                events = new LinkedList<Object>();
                this.typedListenerEvents.put(listener, events);
            }
            events.add(event);
        }

        public Map getGenericListenerEvents() {
            return this.genericListenerEvents;
        }

        public Map getTypedListenerEvents() {
            return this.typedListenerEvents;
        }
    }
}

