/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.internal.setup;

import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.rtc.common.internal.setup.ISetupStore;
import java.util.HashMap;
import java.util.Map;

public class SetupStore
implements ISetupStore {
    private Map<String, Object> fPersistentStore = new HashMap<String, Object>();
    private Map<String, Object> fInternalStore = new HashMap<String, Object>();
    private ItemHandleAwareHashMap fReverseItemStore = new ItemHandleAwareHashMap();

    @Override
    public <T> T get(String key) {
        return (T)(this.fInternalStore.containsKey(key) ? this.fInternalStore.get(key) : this.fPersistentStore.get(key));
    }

    @Override
    public <T> void set(String key, T value) {
        this.set(key, value, false);
    }

    @Override
    public <T> void set(String key, T value, boolean persist) {
        if (persist) {
            this.fPersistentStore.put(key, value);
        } else {
            this.fInternalStore.put(key, value);
            if (value instanceof IItemHandle) {
                this.fReverseItemStore.put(value, (Object)key);
            }
        }
    }

    @Override
    public void clear() {
        this.clear(false);
    }

    @Override
    public void clear(boolean clearPersisted) {
        this.fInternalStore.clear();
        this.fReverseItemStore.clear();
        if (clearPersisted) {
            this.fPersistentStore.clear();
        }
    }

    @Override
    public boolean contains(String key) {
        return this.fInternalStore.containsKey(key) || this.fPersistentStore.containsKey(key);
    }

    @Override
    public <T> void update(T value) {
        if (value instanceof IItem && this.fReverseItemStore.containsKey(value)) {
            this.fInternalStore.put((String)this.fReverseItemStore.get(value), value);
        }
    }
}

