/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.internal.setup.builders;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BuildContext {
    public static final ValueKey<IProjectArea> PROJECT_AREA = new ValueKey(String.valueOf(BuildContext.class.getName()) + ".projectArea");
    public static final ValueKey<IDevelopmentLine> DEVELOPMENT_LINE = new ValueKey(String.valueOf(BuildContext.class.getName()) + ".developmentLine");
    public static final ValueKey<IIterationHandle> ITERATION = new ValueKey(String.valueOf(BuildContext.class.getName()) + ".iterationHandle");
    public static final ValueKey<ITeamArea> TEAM_AREA = new ValueKey(String.valueOf(BuildContext.class.getName()) + ".teamArea");
    public static final ValueKey<ProcessItemMap> BULK_PROCESS_SAVE = new ValueKey(String.valueOf(BuildContext.class.getName()) + ".bulkProcessSave");
    private Map<ValueKey<?>, Object> fProperties;
    private Map<UUID, IItem> fUpdatedItems;

    public BuildContext() {
        this.fProperties = new HashMap();
        this.fUpdatedItems = new HashMap<UUID, IItem>();
    }

    public BuildContext(BuildContext buildContext) {
        this.fProperties = new HashMap(buildContext.fProperties);
        this.fUpdatedItems = buildContext.fUpdatedItems;
    }

    public <T> T getProperty(ValueKey<T> property) {
        IItem i;
        Object item = this.fProperties.get(property);
        if (item instanceof IItem && (i = this.fUpdatedItems.get(((IItem)item).getItemHandle().getItemId())) != null) {
            return (T)i;
        }
        return (T)item;
    }

    public <T> BuildContext setProperty(ValueKey<T> key, T property) {
        this.fProperties.put(key, property);
        return this;
    }

    public <T> boolean isPropertySet(ValueKey<T> key) {
        return this.fProperties.containsKey(key);
    }

    public void updateItem(IItem item) {
        this.fUpdatedItems.put(item.getItemHandle().getItemId(), item);
    }

    public <T extends IItem> T getUpdatedItem(T item) {
        IItem result = this.fUpdatedItems.get(item.getItemHandle().getItemId());
        return (T)(result != null ? result : item);
    }

    public <T extends IProcessItem> void addToBulkSave(T item, IArtifactBuilder<T> builder) {
        ProcessItemMap property = this.getProperty(BULK_PROCESS_SAVE);
        if (property == null) {
            this.setProperty(BULK_PROCESS_SAVE, new ProcessItemMap());
        }
        this.getProperty(BULK_PROCESS_SAVE).put(item, builder);
    }

    public void addToBulkSave(IProcessItem item) {
        this.addToBulkSave(item, null);
    }

    public static class ProcessItemMap {
        private List<IProcessItem> fProcessItems = new LinkedList<IProcessItem>();
        private List<IArtifactBuilder<? extends IProcessItem>> fBuilders = new LinkedList<IArtifactBuilder<? extends IProcessItem>>();

        public <T extends IProcessItem> void put(T processItem, IArtifactBuilder<T> builder) {
            this.put(this.fProcessItems.size(), processItem, builder);
        }

        public <T extends IProcessItem> void put(int location, T processItem, IArtifactBuilder<T> builder) {
            if (processItem == null || this.containsKey(processItem)) {
                return;
            }
            this.fProcessItems.add(location, processItem);
            this.fBuilders.add(location, builder);
        }

        public IArtifactBuilder<? extends IProcessItem> get(IProcessItem processItem) {
            int i = 0;
            while (i < this.fProcessItems.size()) {
                if (this.fProcessItems.get(i).sameItemId((IItemHandle)processItem)) {
                    return this.fBuilders.get(i);
                }
                ++i;
            }
            return null;
        }

        public boolean containsKey(IProcessItem processItem) {
            int i = 0;
            while (i < this.fProcessItems.size()) {
                if (this.fProcessItems.get(i).sameItemId((IItemHandle)processItem)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public int size() {
            return this.fProcessItems.size();
        }

        public List<IProcessItem> keySet() {
            return this.fProcessItems;
        }
    }
}

