/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence;

import com.urbancode.commons.util.crypto.SecureRandomHelper;
import com.urbancode.persistence.IDGenerator;
import java.security.SecureRandom;
import java.util.UUID;

public class IDGeneratorSeqRand
extends IDGenerator {
    private static final String SCALE_KEY = "com.urbancode.persistence.IDGeneratorSeqRand.scale";
    private static final int SCALE_DEFAULT = 5;
    private final State[] states;

    static int getScale() {
        int bits = Integer.getInteger(SCALE_KEY, 5);
        if (bits < 0) {
            bits = 0;
        }
        if (bits > 30) {
            bits = 30;
        }
        return bits;
    }

    public IDGeneratorSeqRand() {
        this(IDGeneratorSeqRand.getScale());
    }

    public IDGeneratorSeqRand(int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale < 0");
        }
        if (scale > 30) {
            throw new IllegalArgumentException("scale > 30");
        }
        this.states = new State[1 << scale];
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = new State();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID newID() {
        State state;
        State state2 = state = this.getState(Thread.currentThread());
        synchronized (state2) {
            long t = state.tick();
            long hi = t << 20 | (long)state.nextInt() & 0xFFFFFL;
            long lo = state.nextLong();
            return new UUID(hi, lo);
        }
    }

    State getState(Thread thread) {
        return this.states[this.getIndex(thread)];
    }

    int getIndex(Thread thread) {
        int mask = this.states.length - 1;
        return thread.hashCode() & mask;
    }

    static final class State {
        private final SecureRandom random = SecureRandomHelper.createNewSecureRandom();
        private long clock;

        State() {
        }

        long tick() {
            this.clock = Math.max(System.currentTimeMillis(), this.clock + 1L);
            return this.clock;
        }

        int nextInt() {
            return this.random.nextInt();
        }

        long nextLong() {
            return this.random.nextLong();
        }
    }
}

