/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate;

import com.urbancode.persistence.hibernate.HibernateUtil;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.AccessType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
@AccessType(value="field")
public abstract class AbstractEntity<I extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 2806840540448132368L;
    @Basic
    @NotNull
    @Version
    @Column(name="version")
    private Long version;

    protected static List<AbstractEntity<Serializable>> getAll(Class<? extends AbstractEntity<Serializable>> clazz) {
        Session session = HibernateUtil.getCurrentSession();
        Criteria criteria = session.createCriteria(clazz);
        List result = criteria.list();
        return result;
    }

    protected static <T extends AbstractEntity> List<T> getAll(Class<T> clazz, String propertyName, boolean asc) {
        Session session = HibernateUtil.getCurrentSession();
        Criteria criteria = session.createCriteria(clazz);
        Order order = asc ? Order.asc((String)propertyName) : Order.desc((String)propertyName);
        criteria.addOrder(order);
        return criteria.list();
    }

    protected static <T extends AbstractEntity<Serializable>> T getById(Class<T> clazz, Serializable id) {
        if (id == null) {
            throw new IllegalArgumentException("The parameter id must be non-null.");
        }
        return AbstractEntity.getByUniqueProperty(clazz, "id", id);
    }

    protected static <T extends AbstractEntity<Serializable>> T getByName(Class<T> clazz, Serializable name) {
        return AbstractEntity.getByUniqueProperty(clazz, "name", name);
    }

    protected static <T extends AbstractEntity> T getByUniqueProperty(Class<T> clazz, String propertyName, Object value) {
        Session session = HibernateUtil.getCurrentSession();
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
        return (T)((AbstractEntity)criteria.uniqueResult());
    }

    protected AbstractEntity() {
    }

    public abstract I getId();

    public Long getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof AbstractEntity) {
            AbstractEntity other = (AbstractEntity)obj;
            result = other.getId().equals(this.getId());
        }
        return result;
    }

    public int hashCode() {
        int hash;
        if (this.getId() != null) {
            hash = 1;
            hash = hash * 31 + this.getClass().hashCode();
            hash = hash * 31 + this.getId().hashCode();
        } else {
            hash = super.hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.getId();
    }
}

