/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate;

import com.urbancode.persistence.hibernate.SessionLocal;
import com.urbancode.persistence.hibernate.TxManagerSessionGuard;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.DetachedCriteria;

public class TxManager {
    private static final Logger log = Logger.getLogger(TxManager.class);
    private final SessionFactory factory;
    private final ThreadLocal<TxState> state;

    public TxManager(SessionFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.factory = factory;
        this.state = new ThreadLocal<TxState>(){

            @Override
            protected TxState initialValue() {
                return new TxState();
            }
        };
    }

    public void close() {
        this.factory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean begin() {
        boolean result;
        TxState ts = this.state.get();
        ts.logBeginPoint();
        if (!ts.isActive()) {
            if (ts.session != null || ts.tx != null || ts.nesting != 0) {
                this.reset(ts);
                throw new RuntimeException("BUG: TX state is not clean");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Beginning TX");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Opening new session");
            }
            ts.session = new TxManagerSessionGuard(this, this.factory.openSession());
            if (!ts.session.isOpen()) {
                this.reset(ts);
                throw new RuntimeException("New session not open");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Getting current transaction");
            }
            ts.tx = ts.session.getTransaction0();
            if (ts.tx.isActive()) {
                this.reset(ts);
                throw new RuntimeException("BUG: TX already active");
            }
            boolean ok = false;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Beginning physical TX");
                }
                ts.nesting = 1;
                ts.needsRollback = true;
                ts.tx.begin();
                ok = true;
            }
            finally {
                if (!ok) {
                    ts.reset();
                }
            }
            result = true;
        } else {
            if (ts.nesting <= 0) {
                throw new RuntimeException("BUG: TX nesting level is invalid");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Beginning nested TX");
            }
            ts.nesting++;
            result = false;
        }
        return result;
    }

    public void forceBegin() {
        TxState ts = this.state.get();
        if (ts.inPreCommitWork) {
            throw new RuntimeException("Cannot modify transaction state in pre-commit work");
        }
        this.state.get().resetAndBugCheck();
        this.begin();
    }

    public void commit() {
        TxState ts = this.state.get();
        if (!ts.isActive()) {
            throw new RuntimeException("TX is not active");
        }
        if (ts.inPreCommitWork && ts.nesting <= 1) {
            throw new RuntimeException("Cannot modify transaction state in pre-commit work");
        }
        if (ts.nesting <= 0) {
            throw new RuntimeException("BUG: TX nesting level is invalid");
        }
        ts.logCommitPoint();
        if (ts.nesting == 1) {
            this.doFinalCommit();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Skipping commit: in nested TX");
        }
    }

    protected void doFinalCommit() {
        TxState ts = this.state.get();
        ts.doPreCommitWork();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Committing TX");
        }
        ts.tx.commit();
        if (log.isDebugEnabled()) {
            log.debug((Object)"TX committed without error");
        }
        ts.needsRollback = false;
        ts.doPostCommitWork();
    }

    public void end() {
        this.doEnd(false);
    }

    public void forceEnd() {
        this.doEnd(true);
        this.state.get().resetAndBugCheck();
    }

    public Session getSession() {
        TxState ts = this.state.get();
        if (!ts.isActive()) {
            throw new RuntimeException("TX is not active");
        }
        return ts.session;
    }

    public boolean isActive() {
        TxState ts = this.state.get();
        return ts.isActive();
    }

    public void commitAndBegin() {
        TxState ts = this.state.get();
        if (!ts.isActive()) {
            throw new RuntimeException("TX is not active");
        }
        if (ts.inPreCommitWork) {
            throw new RuntimeException("Cannot modify transaction state in pre-commit work");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Committing and beginning TX");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Committing TX");
        }
        ts.doPreCommitWork();
        ts.logCommitPoint();
        ts.tx.commit();
        ts.needsRollback = false;
        ts.doPostCommitWork();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting current transaction");
        }
        ts.tx = ts.session.getTransaction0();
        if (ts.tx.isActive()) {
            throw new RuntimeException("BUG: TX already active");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Beginning physical TX");
        }
        ts.logBeginPoint();
        ts.needsRollback = true;
        ts.tx.begin();
    }

    public void queuePreCommitWork(Runnable r) {
        TxState ts = this.state.get();
        if (!ts.isActive()) {
            throw new RuntimeException("TX is not active");
        }
        if (ts.inPreCommitWork) {
            throw new RuntimeException("Cannot queue pre-commit work in pre-commit work");
        }
        ts.queuePreCommitWork(r);
    }

    public void queuePostCommitWork(Runnable r) {
        TxState ts = this.state.get();
        if (!ts.isActive()) {
            throw new RuntimeException("TX is not active");
        }
        ts.queuePostCommitWork(r);
    }

    public void queueFinallyWork(Runnable r) {
        TxState ts = this.state.get();
        if (ts.nesting <= 0) {
            throw new RuntimeException("TX not begun");
        }
        ts.queueFinallyWork(r);
    }

    public Criteria getExecutableCriteria(DetachedCriteria detachedCriteria) {
        TxState ts = this.state.get();
        if (!ts.isActive()) {
            throw new RuntimeException("TX is not active");
        }
        return ts.session.getExecutableCriteria0(detachedCriteria);
    }

    TxState getTxState() {
        return this.state.get();
    }

    private void doEnd(boolean forced) {
        TxState ts = this.state.get();
        if (ts.inPreCommitWork && forced) {
            throw new RuntimeException("Cannot modify transaction state in pre-commit work");
        }
        ts.logRollbackPoint();
        if (forced) {
            if (ts.nesting != 1) {
                log.error((Object)"BUG: forceEnd() not paired with begin()", (Throwable)new Exception("STACKTRACE"));
            }
            ts.nesting = 0;
        } else if (ts.inPreCommitWork && ts.nesting <= 1) {
            log.error((Object)"BUG: end() not paired with begin() in pre-commit work", (Throwable)new Exception("STACKTRACE"));
            ts.nesting = 0;
        } else if (ts.nesting <= 0) {
            log.error((Object)"BUG: end() not paired with begin()", (Throwable)new Exception("STACKTRACE"));
            ts.nesting = 0;
        } else {
            ts.nesting--;
        }
        if (ts.nesting == 0) {
            this.reset(ts);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Skipping rollback: in nested TX");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(TxState ts) {
        try {
            if (ts.needsRollback && ts.tx != null && ts.tx.isActive()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Rolling back TX");
                    }
                    ts.tx.rollback();
                }
                catch (Throwable t) {
                    log.error((Object)"Exception in rollback", t);
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Skipping rollback: not required");
            }
        }
        finally {
            ts.reset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TxState {
        private TxManagerSessionGuard session;
        private Transaction tx;
        private int nesting;
        private boolean needsRollback;
        private boolean inPreCommitWork;
        private List<Exception> eventPoints;
        private List<Runnable> preCommitWork;
        private List<Runnable> postCommitWork;
        private List<Runnable> finallyWork;
        private WeakHashMap<SessionLocal<?>, Object> sessionLocalMap;

        TxState() {
        }

        void logEventPoint(String msg) {
            if (log.isDebugEnabled()) {
                if (this.eventPoints == null) {
                    this.eventPoints = new ArrayList<Exception>();
                }
                this.eventPoints.add(new Exception(msg));
            }
        }

        void logBeginPoint() {
            this.logEventPoint("BEGIN POINT");
        }

        void logCommitPoint() {
            this.logEventPoint("COMMIT POINT");
        }

        void logRollbackPoint() {
            this.logEventPoint("ROLLBACK POINT");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resetting TX state");
            }
            TxManagerSessionGuard localSession = this.session;
            Transaction localTx = this.tx;
            this.session = null;
            this.tx = null;
            this.nesting = 0;
            this.needsRollback = false;
            this.inPreCommitWork = false;
            this.eventPoints = null;
            this.sessionLocalMap = null;
            if (log.isDebugEnabled() && this.preCommitWork != null && !this.preCommitWork.isEmpty()) {
                log.debug((Object)"Discarding pre-commit work that was not executed.");
            }
            this.preCommitWork = null;
            if (log.isDebugEnabled() && this.postCommitWork != null && !this.postCommitWork.isEmpty()) {
                log.debug((Object)"Discarding post-commit work that was not executed.");
            }
            this.postCommitWork = null;
            try {
                try {
                    if (localTx != null && localTx.isActive()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Rolling back TX");
                        }
                        localTx.rollback();
                    }
                }
                finally {
                    if (localSession != null && localSession.isOpen()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Closing session");
                        }
                        localSession.close0();
                    }
                }
            }
            catch (Throwable e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exception in reset", e);
                }
            }
            finally {
                this.doFinallyWork();
            }
        }

        boolean isActive() {
            return this.session != null && this.tx != null && this.session.isOpen() && this.tx.isActive();
        }

        void resetAndBugCheck() {
            if (this.isActive()) {
                log.error((Object)"BUG: TX is active", (Throwable)new Exception("STACKTRACE"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Forcing TX termination");
                    if (this.eventPoints != null) {
                        log.debug((Object)"TX event points:");
                        for (Exception e : this.eventPoints) {
                            log.debug((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            this.reset();
        }

        void queuePreCommitWork(Runnable r) {
            if (r != null) {
                if (this.preCommitWork == null) {
                    this.preCommitWork = new ArrayList<Runnable>();
                }
                this.preCommitWork.add(r);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Queued pre-commit work: " + r));
                }
            }
        }

        void queuePostCommitWork(Runnable r) {
            if (r != null) {
                if (this.postCommitWork == null) {
                    this.postCommitWork = new ArrayList<Runnable>();
                }
                this.postCommitWork.add(r);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Queued post-commit work: " + r));
                }
            }
        }

        void queueFinallyWork(Runnable r) {
            if (r != null) {
                if (this.finallyWork == null) {
                    this.finallyWork = new ArrayList<Runnable>();
                }
                this.finallyWork.add(r);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Queued finally work: " + r));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doPreCommitWork() {
            int originalNesting = this.nesting;
            this.inPreCommitWork = true;
            try {
                List<Runnable> localPreCommitWork = this.preCommitWork;
                this.preCommitWork = null;
                if (localPreCommitWork != null) {
                    for (Runnable r : localPreCommitWork) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Executing pre-commit work: " + r));
                        }
                        r.run();
                        if (originalNesting == this.nesting) continue;
                        throw new RuntimeException("BUG: TX nesting level is unbalanced in pre-commit work");
                    }
                }
            }
            finally {
                this.inPreCommitWork = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doPostCommitWork() {
            List<Runnable> localPostCommitWork = this.postCommitWork;
            this.postCommitWork = null;
            if (localPostCommitWork != null) {
                TxState temp = new TxState();
                this.swap(temp);
                try {
                    for (Runnable r : localPostCommitWork) {
                        this.clear();
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Executing post-commit work: " + r));
                            }
                            r.run();
                        }
                        finally {
                            this.resetAndBugCheck();
                        }
                    }
                }
                finally {
                    temp.swap(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doFinallyWork() {
            List<Runnable> localFinallyWork = this.finallyWork;
            this.finallyWork = null;
            if (localFinallyWork != null) {
                for (Runnable r : localFinallyWork) {
                    try {
                        this.clear();
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Executing finally work: " + r));
                            }
                            r.run();
                        }
                        finally {
                            this.resetAndBugCheck();
                        }
                    }
                    catch (Throwable t) {
                        log.error((Object)"Error running finally work", t);
                    }
                }
            }
        }

        void swap(TxState ts) {
            TxManagerSessionGuard localSesion = this.session;
            Transaction localTx = this.tx;
            int localNesting = this.nesting;
            boolean localNeedsRollback = this.needsRollback;
            boolean localInPreCommitWork = this.inPreCommitWork;
            List<Exception> localEventPoints = this.eventPoints;
            List<Runnable> localPreCommitWork = this.preCommitWork;
            List<Runnable> localPostCommitWork = this.postCommitWork;
            List<Runnable> localFinallyWork = this.finallyWork;
            WeakHashMap<SessionLocal<?>, Object> localSessionLocalMap = this.sessionLocalMap;
            this.session = ts.session;
            this.tx = ts.tx;
            this.nesting = ts.nesting;
            this.needsRollback = ts.needsRollback;
            this.inPreCommitWork = ts.inPreCommitWork;
            this.eventPoints = ts.eventPoints;
            this.preCommitWork = ts.preCommitWork;
            this.postCommitWork = ts.postCommitWork;
            this.finallyWork = ts.finallyWork;
            this.sessionLocalMap = ts.sessionLocalMap;
            ts.session = localSesion;
            ts.tx = localTx;
            ts.nesting = localNesting;
            ts.needsRollback = localNeedsRollback;
            ts.inPreCommitWork = localInPreCommitWork;
            ts.eventPoints = localEventPoints;
            ts.preCommitWork = localPreCommitWork;
            ts.postCommitWork = localPostCommitWork;
            ts.finallyWork = localFinallyWork;
            ts.sessionLocalMap = localSessionLocalMap;
        }

        void clear() {
            this.session = null;
            this.tx = null;
            this.nesting = 0;
            this.needsRollback = false;
            this.inPreCommitWork = false;
            this.eventPoints = null;
            this.preCommitWork = null;
            this.postCommitWork = null;
            this.finallyWork = null;
            this.sessionLocalMap = null;
        }

        Map<SessionLocal<?>, Object> getSessionLocalMap() {
            return this.sessionLocalMap;
        }

        Map<SessionLocal<?>, Object> initSessionLocalMap() {
            if (this.sessionLocalMap == null) {
                this.sessionLocalMap = new WeakHashMap();
            }
            return this.sessionLocalMap;
        }

        boolean isSessionLocalStorageActive() {
            return this.session != null && this.session.isOpen();
        }
    }
}

