/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate.audit;

import com.urbancode.persistence.hibernate.audit.event.AbstractAuditEvent;
import com.urbancode.persistence.hibernate.audit.event.Change;
import com.urbancode.persistence.hibernate.audit.event.IAuditEventProcessor;
import com.urbancode.persistence.hibernate.audit.event.UpdateAuditEvent;
import java.io.PrintStream;

public class PrintStreamLoggingEventProcessor
implements IAuditEventProcessor {
    private final PrintStream out;
    private final boolean skipFlushMessage;

    public PrintStreamLoggingEventProcessor(PrintStream out) {
        this(out, false);
    }

    public PrintStreamLoggingEventProcessor(PrintStream out, boolean skipFlushMessage) {
        this.out = out;
        this.skipFlushMessage = skipFlushMessage;
    }

    public void processAuditEvent(AbstractAuditEvent event) {
        this.out.println("event " + (Object)((Object)event.getType()) + " on " + event.getEntity().getClass().getSimpleName() + "#" + event.getEntity().getId());
        if (event instanceof UpdateAuditEvent) {
            UpdateAuditEvent updateAuditEvent = (UpdateAuditEvent)event;
            for (Change change : updateAuditEvent.getChanges()) {
                this.out.println("\t" + change);
            }
        }
    }

    public void flush() {
        if (!this.skipFlushMessage) {
            this.out.println("*** FINISHED ***");
        }
    }
}

