/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import com.jayway.restassured.filter.log.LogDetail;
import java.io.PrintStream;
import org.apache.commons.lang3.Validate;

public class LogConfig {
    private final PrintStream defaultPrintStream;
    private final boolean prettyPrintingEnabled;
    private final LogDetail logDetailIfValidationFails;

    public LogConfig() {
        this(System.out, true);
    }

    public LogConfig(PrintStream defaultPrintStream, boolean prettyPrintingEnabled) {
        this(defaultPrintStream, prettyPrintingEnabled, null);
    }

    private LogConfig(PrintStream defaultPrintStream, boolean prettyPrintingEnabled, LogDetail logDetailIfValidationFails) {
        Validate.notNull(defaultPrintStream, "Stream to write logs to cannot be null", new Object[0]);
        this.defaultPrintStream = defaultPrintStream;
        this.prettyPrintingEnabled = prettyPrintingEnabled;
        this.logDetailIfValidationFails = logDetailIfValidationFails;
    }

    public PrintStream defaultStream() {
        return this.defaultPrintStream;
    }

    public LogConfig defaultStream(PrintStream printStream) {
        return new LogConfig(printStream, true, this.logDetailIfValidationFails);
    }

    public boolean isPrettyPrintingEnabled() {
        return this.prettyPrintingEnabled;
    }

    public boolean isLoggingOfRequestAndResponseIfValidationFailsEnabled() {
        return this.logDetailIfValidationFails != null;
    }

    public LogDetail logDetailOfRequestAndResponseIfValidationFails() {
        return this.logDetailIfValidationFails;
    }

    public LogConfig enablePrettyPrinting(boolean shouldEnable) {
        return new LogConfig(this.defaultPrintStream, shouldEnable, this.logDetailIfValidationFails);
    }

    public LogConfig enableLoggingOfRequestAndResponseIfValidationFails() {
        return this.enableLoggingOfRequestAndResponseIfValidationFails(LogDetail.ALL);
    }

    public LogConfig enableLoggingOfRequestAndResponseIfValidationFails(LogDetail logDetail) {
        return new LogConfig(this.defaultPrintStream, this.prettyPrintingEnabled, logDetail);
    }

    public static LogConfig logConfig() {
        return new LogConfig();
    }

    public LogConfig and() {
        return this;
    }
}

