/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression.variables;

import com.ibm.icu.util.Calendar;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.variables.AbstractAttributeVariable;
import com.ibm.team.workitem.common.expression.variables.IEvaluationContext;
import com.ibm.team.workitem.common.expression.variables.Messages;
import com.ibm.team.workitem.common.expression.variables.TimeSpan;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

public class RelativeDateVariable
extends AbstractAttributeVariable<TimeSpan> {
    public static final String VARIABLE_ID = "now";
    private static Pattern fgVariableFormat = Pattern.compile("-?(\\d+)(\\D*)");
    private RelativeDate fRelativeDate;

    RelativeDateVariable() {
    }

    public RelativeDateVariable(TimeUnit unit, int timeSpan) {
        this.fRelativeDate = new RelativeDate(unit, timeSpan);
    }

    public RelativeDateVariable(String value) {
        this.setArguments(value);
    }

    @Override
    public String getDisplayName() {
        return this.getArguments();
    }

    @Override
    public String getId() {
        return VARIABLE_ID;
    }

    public TimeUnit getTimeUnit() {
        return this.fRelativeDate == null ? null : this.fRelativeDate.fTimeUnit;
    }

    public int getTimeSpan() {
        return this.fRelativeDate == null ? 0 : this.fRelativeDate.fTimeSpan;
    }

    @Override
    public Collection<TimeSpan> evaluate(IEvaluationContext context, IProgressMonitor monitor) {
        int calendarUnit = this.getTimeUnit().getCalendarUnit();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(calendarUnit, this.getTimeSpan() * (this.getTimeUnit().isPast() ? -1 : 1));
        Timestamp reference = new Timestamp(cal.getTimeInMillis());
        TimeSpan timeSpan = TimeSpan.createTimeSpan(reference, calendarUnit, context.getTimeZone());
        return Collections.singleton(timeSpan);
    }

    @Override
    public String getArguments() {
        return this.getTimeUnit().getValue(this.getTimeSpan());
    }

    @Override
    public void setArguments(String arguments) {
        this.fRelativeDate = RelativeDateVariable.getRelativeDate(arguments);
        if (this.fRelativeDate == null) {
            String error = NLS.bind((String)Messages.getString("RelativeDateVariable.INVALID_INPUT"), (Object)(arguments == null ? "null" : arguments), (Object[])new Object[0]);
            throw new IllegalArgumentException(error);
        }
    }

    private static RelativeDate getRelativeDate(String arguments) {
        if (arguments == null) {
            return null;
        }
        Matcher matcher = fgVariableFormat.matcher(arguments);
        if (matcher.matches()) {
            String number = matcher.group(1);
            Integer timeSpan = Integer.valueOf(number);
            String unitPart = matcher.group(2);
            if (unitPart.trim().length() == 0) {
                arguments = String.valueOf(arguments) + 'd';
            }
            TimeUnit[] timeUnitArray = TimeUnit.values();
            int n = timeUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                TimeUnit unit = timeUnitArray[n2];
                if (unit.getValue(timeSpan).equalsIgnoreCase(arguments)) {
                    return new RelativeDate(unit, timeSpan);
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isValid(String value) {
        return RelativeDateVariable.getRelativeDate(value) != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RelativeDateVariable)) {
            return false;
        }
        return ((RelativeDateVariable)o).getArguments().equals(this.getArguments());
    }

    public int hashCode() {
        return VARIABLE_ID.hashCode();
    }

    private static class RelativeDate {
        TimeUnit fTimeUnit;
        Integer fTimeSpan;

        public RelativeDate(TimeUnit timeUnit, Integer timeSpan) {
            this.fTimeUnit = timeUnit;
            this.fTimeSpan = timeSpan;
        }
    }

    public static enum TimeUnit {
        MINUTES_AGO("-%dmin", 12),
        HOURS_AGO("-%dh", 11),
        DAYS_AGO("-%dd", 5),
        MONTHS_AGO("-%dm", 2),
        YEARS_AGO("-%dy", 1),
        MINUTES_FROM_NOW("%dmin", 12),
        HOURS_FROM_NOW("%dh", 11),
        DAYS_FROM_NOW("%dd", 5),
        MONTHS_FROM_NOW("%dm", 2),
        YEARS_FROM_NOW("%dy", 1);

        private final String fFormat;
        private final int fCalendarUnit;

        private TimeUnit(String format, int calendarUnit) {
            this.fFormat = format;
            this.fCalendarUnit = calendarUnit;
        }

        public boolean isPast() {
            return this.fFormat.charAt(0) == '-';
        }

        private String getValue(int timeSpan) {
            return String.format(this.fFormat, timeSpan);
        }

        private int getCalendarUnit() {
            return this.fCalendarUnit;
        }
    }
}

