/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class ChangeSetTracker {
    private Comparator<IChangeSet> comparator;
    private Map<UUID, Long> timeMap;
    private Map<UUID, IChangeSet> uuidMap;
    private Set<IChangeSet> changeSets;
    private Map<UUID, Set<IChangeSet>> byComponents;

    public ChangeSetTracker() {
        this(null);
    }

    public ChangeSetTracker(Comparator<IChangeSet> comparator) {
        if (comparator == null) {
            this.timeMap = new HashMap<UUID, Long>();
            comparator = new TimeComparator();
        }
        this.comparator = comparator;
        this.uuidMap = new HashMap<UUID, IChangeSet>();
        this.changeSets = new TreeSet<IChangeSet>(this.comparator);
        this.byComponents = new HashMap<UUID, Set<IChangeSet>>();
    }

    public List<IChangeSetHandle> getChangeSets() {
        return Collections.unmodifiableList(new ArrayList<IChangeSet>(this.changeSets));
    }

    public List<IChangeSetHandle> getByComponent(IComponentHandle component) {
        Set<IChangeSet> set = this.byComponents.get(component.getItemId());
        if (set == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(new ArrayList<IChangeSet>(set));
    }

    public void addChangeSet(IChangeSet changeSet) {
        UUID componentUuid;
        Set<IChangeSet> byComponent;
        UUID csItemId = changeSet.getItemId();
        Long time = null;
        if (this.timeMap != null) {
            time = this.timeMap.get(csItemId);
        }
        this.removeChangeSet((IChangeSetHandle)changeSet);
        if (this.timeMap != null) {
            if (time == null) {
                time = System.currentTimeMillis();
            }
            this.timeMap.put(csItemId, time);
        }
        if ((byComponent = this.byComponents.get(componentUuid = changeSet.getComponent().getItemId())) == null) {
            byComponent = new TreeSet<IChangeSet>(this.comparator);
            this.byComponents.put(componentUuid, byComponent);
        }
        this.uuidMap.put(csItemId, changeSet);
        this.changeSets.add(changeSet);
        byComponent.add(changeSet);
    }

    public IComponentHandle getComponentForChangeSet(IChangeSetHandle changeSet) {
        IChangeSet oldCS = this.uuidMap.get(changeSet.getItemId());
        if (oldCS != null) {
            return oldCS.getComponent();
        }
        return null;
    }

    public void removeChangeSet(IChangeSetHandle changeSet) {
        UUID csItemId = changeSet.getItemId();
        IChangeSet oldCS = this.uuidMap.get(csItemId);
        if (oldCS != null) {
            UUID componentUuid = oldCS.getComponent().getItemId();
            Set<IChangeSet> byComponent = this.byComponents.get(componentUuid);
            if (byComponent != null) {
                byComponent.remove(oldCS);
                if (byComponent.isEmpty()) {
                    this.byComponents.remove(componentUuid);
                }
            }
            this.uuidMap.remove(csItemId);
            this.changeSets.remove(oldCS);
            if (this.timeMap != null) {
                this.timeMap.remove(csItemId);
            }
        }
    }

    private class TimeComparator
    implements Comparator<IChangeSet> {
        private TimeComparator() {
        }

        @Override
        public int compare(IChangeSet o1, IChangeSet o2) {
            if (o1.sameItemId((IItemHandle)o2)) {
                return 0;
            }
            Long t1 = (Long)ChangeSetTracker.this.timeMap.get(o1.getItemId());
            Long t2 = (Long)ChangeSetTracker.this.timeMap.get(o2.getItemId());
            int compareTo = t2.compareTo(t1);
            if (compareTo == 0) {
                compareTo = o1.getItemId().compareTo((Object)o2.getItemId());
            }
            return compareTo;
        }
    }
}

