/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.internal.support;

import com.jayway.restassured.config.ConnectionConfig;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.conn.ClientConnectionManager;

public class CloseHTTPClientConnectionInputStreamWrapper
extends InputStream {
    private ConnectionConfig connectionConfig;
    private final ClientConnectionManager connectionManager;
    private final InputStream wrapped;

    public CloseHTTPClientConnectionInputStreamWrapper(ConnectionConfig connectionConfig, ClientConnectionManager connectionManager, InputStream wrapped) {
        this.connectionConfig = connectionConfig;
        this.connectionManager = connectionManager;
        this.wrapped = wrapped;
    }

    public int read() throws IOException {
        return this.wrapped.read();
    }

    public int read(byte[] b) throws IOException {
        return this.wrapped.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.wrapped.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.wrapped.skip(n);
    }

    public int available() throws IOException {
        return this.wrapped.available();
    }

    public void close() throws IOException {
        if (this.connectionManager != null && this.connectionConfig.shouldCloseIdleConnectionsAfterEachResponse()) {
            this.connectionManager.closeIdleConnections(this.connectionConfig.closeIdleConnectionConfig().getIdleTime(), this.connectionConfig.closeIdleConnectionConfig().getTimeUnit());
        }
        this.wrapped.close();
    }

    public void mark(int readlimit) {
        this.wrapped.mark(readlimit);
    }

    public void reset() throws IOException {
        this.wrapped.reset();
    }

    public boolean markSupported() {
        return this.wrapped.markSupported();
    }
}

