/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.framework.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.urbancode.release.rest.framework.ClientEntity;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExplicitNullsDereferencingFactory
implements TypeAdapterFactory {
    protected static Logger log = Logger.getLogger(ExplicitNullsDereferencingFactory.class);
    Map<String, ClientEntity> idMap = new HashMap<String, ClientEntity>();

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (!ClientEntity.class.isAssignableFrom(typeToken.getRawType())) {
            return null;
        }
        TypeAdapter<T> delegate = gson.getDelegateAdapter(this, typeToken);
        TypeAdapter<JsonElement> elementDelegate = gson.getAdapter(JsonElement.class);
        return new ExplicitNullsDereferencingAdapter<T>(delegate, elementDelegate, typeToken, this.idMap).nullSafe();
    }

    protected static class ExplicitNullsDereferencingAdapter<T extends ClientEntity>
    extends TypeAdapter<T> {
        protected TypeAdapter<T> delegate;
        protected TypeAdapter<JsonElement> elementDelegate;
        protected Map<String, ClientEntity> idMap;
        protected TypeToken<T> typeToken;

        public ExplicitNullsDereferencingAdapter(TypeAdapter<T> delegate, TypeAdapter<JsonElement> elementDelegate, TypeToken<T> typeToken, Map<String, ClientEntity> idMap) {
            this.delegate = delegate;
            this.elementDelegate = elementDelegate;
            this.typeToken = typeToken;
            this.idMap = idMap;
        }

        @Override
        public T read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                log.debug("Reading instance of " + this.typeToken.getRawType().getSimpleName());
                JsonObject jo = this.elementDelegate.read(reader).getAsJsonObject();
                if (jo.has("$ref")) {
                    log.debug("Resolving reference to" + this.typeToken.getRawType().getSimpleName());
                    return (T)this.idMap.get(jo.get("$ref").getAsString());
                }
                if (jo.has("id") && jo.get("id").isJsonPrimitive()) {
                    log.debug("Proceeding to full read of " + this.typeToken.getRawType().getSimpleName() + " with id:" + jo.get("id").getAsString());
                } else {
                    log.debug("Proceeding to full read of " + this.typeToken.getRawType().getSimpleName());
                }
                ClientEntity entity = (ClientEntity)this.delegate.fromJsonTree(jo);
                if (jo.has("id") && jo.get("id").isJsonPrimitive()) {
                    log.debug("Finished full read of " + this.typeToken.getRawType().getSimpleName() + " with id:" + jo.get("id").getAsString());
                } else {
                    log.debug("Finished full read of " + this.typeToken.getRawType().getSimpleName());
                }
                this.idMap.put(entity.id, entity);
                return (T)entity;
            }
            if (reader.peek() == JsonToken.STRING) {
                try {
                    ClientEntity t = (ClientEntity)this.typeToken.getRawType().newInstance();
                    return t.id(reader.nextString());
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot create new object of type: " + this.typeToken.getRawType().getSimpleName(), e);
                }
            }
            if (reader.peek() == JsonToken.NULL) {
                return null;
            }
            throw new IllegalStateException("Unexpected JSON token while parsing ClientEntity: " + (Object)((Object)reader.peek()));
        }

        @Override
        public void write(JsonWriter writer, T entity) throws IOException {
            if (entity == null) {
                writer.nullValue();
            } else {
                log.debug("Writing instance of " + this.typeToken.getRawType().getSimpleName());
                JsonObject jo = this.delegate.toJsonTree(entity).getAsJsonObject();
                if (jo.has("id") && jo.get("id").isJsonPrimitive()) {
                    log.debug("Finished first pass writing " + this.typeToken.getRawType().getSimpleName() + " with id:" + jo.getAsJsonPrimitive("id").getAsString());
                } else {
                    log.debug("Finished first pass writing " + this.typeToken.getRawType().getSimpleName());
                }
                Iterator<Map.Entry<String, JsonElement>> it = jo.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, JsonElement> entry = it.next();
                    if (!entry.getValue().isJsonNull()) continue;
                    it.remove();
                }
                for (String nullProp : ((ClientEntity)entity).nulls) {
                    jo.add(nullProp, JsonNull.INSTANCE);
                }
                this.elementDelegate.write(writer, jo);
            }
        }
    }
}

