/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.gson.annotations.SerializedName;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientIntegrated;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.Group;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.internal.CheckpointPlan;
import com.urbancode.release.rest.models.internal.EnvironmentTag;
import com.urbancode.release.rest.models.internal.InternalClients;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.ReleaseSystem;
import com.urbancode.release.rest.models.internal.SuggestedTask;
import com.urbancode.release.rest.models.internal.TaskAttachment;
import com.urbancode.release.rest.models.internal.TaskComment;
import com.urbancode.release.rest.models.internal.TaskTag;
import java.util.HashMap;
import java.util.Map;

public abstract class Task<T extends Task>
extends ClientIntegrated<T> {
    public Boolean automated;
    public Boolean updateVersion;
    public Boolean active;
    public Boolean onlyChangedVersions;
    public Application application;
    public Role executorRole;
    public Group executorGroup;
    public User user;
    public Long duration;
    public ExecutionPattern taskPattern;
    public boolean requireApplicationVersion = true;
    public String executionStep;
    public TagMatch targetMatch;
    public TagMatch tagOption;
    public String[] environments;
    public String[] tags;
    public String[] tagIds;
    public TaskTag[] taskTags;
    @SerializedName(value="taskTypeModuleClassName")
    public TaskType taskType;
    public CheckpointPlan checkpointPlan;
    public ReleaseSystem releaseSystem;
    public Long targetDate;
    public Integer window;
    public OutageMarkerType outageMarkerType;
    @JsonReadOnly
    public String[] prerequisiteIds = new String[0];
    @JsonReadOnly
    public Boolean userCanExecute;
    @JsonReadOnly
    public Boolean belongsToCurrentUser;
    @JsonReadOnly
    public String userName;
    public String userId;
    @JsonReadOnly
    public String[] completeEnvironments;
    @JsonReadOnly
    public TaskComment[] comments;
    @JsonReadOnly
    public SuggestedTask[] suggestionsReferencingThis;
    @JsonReadOnly
    public Integer taskOrderPos;
    @JsonReadOnly
    public User assignedUser;

    public T setAutomated(boolean automated) {
        return this.automated(automated);
    }

    public T automated(boolean automated) {
        this.automated = automated;
        return (T)this;
    }

    public Boolean getAutomated() {
        return this.automated;
    }

    public String getExecutionStep() {
        return this.executionStep;
    }

    public T active(boolean active) {
        this.active = active;
        return (T)this;
    }

    public T executionStep(String executionStep) {
        this.executionStep = executionStep;
        return (T)this;
    }

    public Boolean isActive() {
        return this.active;
    }

    public boolean requireApplicationVersion() {
        return this.requireApplicationVersion;
    }

    public T requireApplicationVersion(boolean requireApplicationVersion) {
        this.requireApplicationVersion = requireApplicationVersion;
        return (T)this;
    }

    public T taskType(TaskType taskType) {
        this.taskType = taskType;
        return (T)this;
    }

    public T checkpointPlan(CheckpointPlan checkpointPlan) {
        this.checkpointPlan = checkpointPlan;
        return (T)this;
    }

    public Task setActive(boolean active) {
        return this.active(active);
    }

    public T onlyChangedVersions(boolean onlyChangedVersions) {
        this.onlyChangedVersions = onlyChangedVersions;
        return (T)this;
    }

    public T updateVersion(boolean updateVersion) {
        this.updateVersion = updateVersion;
        return (T)this;
    }

    public T application(Application application) {
        this.handleNull(application, "application");
        this.application = application;
        return (T)this;
    }

    public T applicationVersionRequired(boolean applicationVersionrequired) {
        this.handleNull(this.application, "application");
        this.requireApplicationVersion = applicationVersionrequired;
        return (T)this;
    }

    public T setApplication(Application application) {
        return this.application(application);
    }

    public T executorRoleOrGroup(Role executorRole) {
        this.handleNull(executorRole, "executorRole");
        this.executorRole = executorRole;
        this.handleNull(null, "executorGroup");
        this.executorGroup = null;
        return (T)this;
    }

    public T executorRoleOrGroup(Group executorGroup) {
        this.handleNull(executorGroup, "executorGroup");
        this.executorGroup = executorGroup;
        this.handleNull(null, "executorRole");
        this.executorRole = null;
        return (T)this;
    }

    public T user(User user) {
        if (this.handleNull(user, "user", "userId")) {
            this.user = user;
            this.userId = user.id;
        } else {
            this.user = null;
            this.userId = null;
        }
        return (T)this;
    }

    public T duration(Long duration) {
        this.duration = duration;
        return (T)this;
    }

    public T taskPattern(ExecutionPattern taskPattern) {
        this.taskPattern = taskPattern;
        return (T)this;
    }

    public T targetMatch(TagMatch targetMatch) {
        this.targetMatch = targetMatch;
        this.tagOption = targetMatch;
        return (T)this;
    }

    public T environments(ReleaseEnvironment ... environments) {
        this.environments = this.handleNull(environments, "environments") ? Task.ids(environments) : new String[0];
        return (T)this;
    }

    public T tags(EnvironmentTag ... tags) {
        if (this.handleNull(tags, "tags", "tagIds")) {
            this.tags = Task.ids(tags);
            this.tagIds = Task.ids(tags);
        } else {
            this.tags = null;
            this.tagIds = null;
        }
        return (T)this;
    }

    public T taskTags(TaskTag ... taskTags) {
        this.handleNull(taskTags, "taskTags");
        this.taskTags = taskTags;
        return (T)this;
    }

    public T getByExternalId(String externalId) {
        return (T)((Task)((Response)RestAssured.expect().contentType(ContentType.JSON).get(this.path() + "externalId/" + externalId, new Object[0])).as(this.getClass(), ObjectMapperType.GSON));
    }

    public T addUCDTaskProperty(String property, String value) {
        if (this.propertyValues.get("UCDProperties") == null) {
            this.setProperty("UCDProperties", "");
        }
        String taskProperties = (String)this.propertyValues.get("UCDProperties");
        Map<String, String> map = this.splitToMap(taskProperties);
        HashMap<String, String> test = new HashMap<String, String>(map);
        test.put(property, value);
        String updatedProperties = Joiner.on("|").withKeyValueSeparator("=").join(test);
        updatedProperties.replace("|", "\n");
        this.setProperty("UCDProperties", updatedProperties);
        this.save();
        return (T)this;
    }

    public ReleaseSystem getReleaseSystem() {
        return this.releaseSystem;
    }

    public T releaseSystem(ReleaseSystem releaseSystem) {
        this.releaseSystem = releaseSystem;
        return (T)this;
    }

    public Map<String, String> getUCDTaskPropertyMap() {
        if (this.propertyValues.get("UCDProperties") == null) {
            return new HashMap<String, String>();
        }
        String taskProperties = (String)this.propertyValues.get("UCDProperties");
        Map<String, String> map = this.splitToMap(taskProperties);
        return map;
    }

    public String getUCDTaskProperty(String property) {
        if (this.propertyValues.get("UCDProperties") == null) {
            return "";
        }
        String taskProperties = (String)this.propertyValues.get("UCDProperties");
        Map<String, String> map = this.splitToMap(taskProperties);
        return map.get(property);
    }

    public void clearUCDTaskProperties() {
        this.propertyValues.put("UCDProperties", "");
    }

    private Map<String, String> splitToMap(String in) {
        if (in.length() > 0) {
            return Splitter.on("\n").withKeyValueSeparator("=").split(in);
        }
        return new HashMap<String, String>();
    }

    public TaskAttachment[] getAttachments() {
        return InternalClients.taskAttachment().getAttachmentsForTask(this.id);
    }

    public Long getTargetDate() {
        return this.targetDate;
    }

    public T targetDate(Long targetDate) {
        this.targetDate = targetDate;
        return (T)this;
    }

    public Integer getWindow() {
        return this.window;
    }

    public T window(Integer window) {
        this.window = window;
        return (T)this;
    }

    public OutageMarkerType getOutageMarkerType() {
        return this.outageMarkerType;
    }

    public T outageMarkerType(OutageMarkerType outageMarkerType) {
        this.outageMarkerType = outageMarkerType;
        return (T)this;
    }

    public static enum OutageMarkerType {
        BEGIN,
        END;

    }

    public static enum TaskType {
        WaitTask,
        SignalTask,
        UCDTask,
        ManualTask,
        NotificationTask,
        PluginTask,
        OutageTask,
        CriticalTimeTask,
        WaitForTimeTask;

    }

    public static enum TagMatch {
        ALL_TARGETS,
        WITH_ALL_OF_TAGS,
        WITH_ANY_OF_TAGS;

    }

    public static enum ExecutionPattern {
        ALWAYS,
        ONCE_PER_ENVIRONMENT;

    }
}

