/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

import com.ibm.team.calm.foundation.common.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class CustomNamespaceContext
implements NamespaceContext {
    private static final String GENERATED_NAMESPACE_PREFIX = "ns";
    private final Map<String, String> fPrefixToUri;

    public CustomNamespaceContext() {
        this(new HashMap<String, String>());
    }

    public CustomNamespaceContext(Map<String, String> prefixToUriMap) throws IllegalArgumentException {
        this.fPrefixToUri = prefixToUriMap != null ? prefixToUriMap : new HashMap();
        for (Map.Entry<String, String> curEntry : this.fPrefixToUri.entrySet()) {
            String curPrefix = curEntry.getKey();
            String curUri = curEntry.getValue();
            if (!this.isInvalidString(curUri) && !this.isInvalidPrefix(curPrefix)) continue;
            throw new IllegalArgumentException();
        }
    }

    public void setPrefixSuggestions(Map<String, String> nsUriToPrefixSuggestions) throws IllegalArgumentException {
        if (nsUriToPrefixSuggestions != null) {
            for (Map.Entry<String, String> curEntry : nsUriToPrefixSuggestions.entrySet()) {
                String curUri = curEntry.getKey();
                String curPrefix = curEntry.getValue();
                if (this.isInvalidString(curUri) || this.isInvalidPrefix(curPrefix)) {
                    throw new IllegalArgumentException();
                }
                this.replaceMapping(curUri, curPrefix);
            }
        }
    }

    public void setPrefixSuggestion(String uri, String prefix) throws IllegalArgumentException {
        if (this.isInvalidString(uri) || this.isInvalidPrefix(prefix)) {
            throw new IllegalArgumentException();
        }
        this.replaceMapping(uri, prefix);
    }

    @Override
    public String getPrefix(String nsUri) {
        return this.getPrefix(nsUri, true);
    }

    public String getPrefix(String nsUri, boolean createIfNotExists) {
        if (nsUri != null) {
            for (Map.Entry<String, String> curEntry : this.fPrefixToUri.entrySet()) {
                String curUri = curEntry.getValue();
                if (!nsUri.equals(curUri)) continue;
                return curEntry.getKey();
            }
            if (createIfNotExists) {
                String suggested = "ns1";
                int count = 2;
                while (this.fPrefixToUri.containsKey(suggested)) {
                    suggested = GENERATED_NAMESPACE_PREFIX + count;
                    ++count;
                }
                this.replaceMapping(nsUri, suggested);
                return suggested;
            }
        }
        return null;
    }

    public Iterator<?> getPrefixes(String nsUri) {
        ArrayList<String> result = new ArrayList<String>();
        if (nsUri != null) {
            for (Map.Entry<String, String> curEntry : this.fPrefixToUri.entrySet()) {
                String curUri = curEntry.getValue();
                String curPrefix = curEntry.getKey();
                if (!nsUri.equals(curUri) || result.contains(curPrefix)) continue;
                result.add(curPrefix);
            }
        }
        return result.iterator();
    }

    public List<String> getNamespaceURIs() {
        return new ArrayList<String>(this.fPrefixToUri.values());
    }

    @Override
    public String getNamespaceURI(String nsPrefix) {
        String ns = this.fPrefixToUri.get(nsPrefix);
        if (ns != null) {
            return ns;
        }
        return "";
    }

    public boolean contains(String namespaceUri) {
        return this.fPrefixToUri.containsValue(namespaceUri);
    }

    public String qualify(Property property) throws IllegalArgumentException {
        return this.qualify(property.getNamespaceURI(), property.getName());
    }

    public String qualify(String nsUri, String localName) throws IllegalArgumentException {
        if (this.isInvalidString(nsUri) || this.isInvalidString(localName)) {
            throw new IllegalArgumentException();
        }
        String prefix = this.getPrefix(nsUri, true);
        return String.format("%s:%s", prefix, localName);
    }

    private boolean isInvalidString(String str) {
        return str == null || str.length() == 0;
    }

    private boolean isInvalidPrefix(String prefix) {
        if (this.isInvalidString(prefix)) {
            return true;
        }
        return prefix.contains(":");
    }

    private String replaceMapping(String curUri, String curPrefix) {
        if (this.fPrefixToUri.containsValue(curUri)) {
            Iterator<Map.Entry<String, String>> it = this.fPrefixToUri.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> cur = it.next();
                if (!cur.getValue().equals(curUri)) continue;
                it.remove();
                break;
            }
        }
        return this.fPrefixToUri.put(curPrefix, curUri);
    }
}

