/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util;

import com.ibm.team.repository.common.internal.content.util.BTreeAllocator;
import com.ibm.team.repository.common.internal.content.util.BTreeComparator;
import com.ibm.team.repository.common.internal.content.util.FileChannelUtil;
import com.ibm.team.repository.common.internal.content.util.RAFWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class BTree {
    protected static final int NODE_HEADER_SIZE = 4;
    protected static final int PTR_SIZE = 8;
    protected int maxCacheSize = 256;
    protected int keySize;
    protected int m;
    protected int minKeys;
    protected boolean doRandom;
    protected int nodeSize;
    protected final BTreeComparator cmp;
    protected final BTreeAllocator allocator;
    protected final Random rnd = new Random();
    protected final RAFWrapper raf;
    protected Map<Long, BTreeNode> nodeCache;
    protected Map<Long, BTreeNode> unusedNodes;
    protected Set<BTreeNode> modifiedNodes;
    protected long root;

    protected BTree(RAFWrapper raf, BTreeComparator comparator, BTreeAllocator allocator) {
        this.raf = raf;
        this.cmp = comparator;
        this.allocator = allocator;
    }

    public BTree(int keySize, int blockSize, BTreeComparator cmp, BTreeAllocator allocator, RAFWrapper raf) {
        this(raf, cmp, allocator);
        this.init(keySize, blockSize, -1L);
    }

    protected void init(int ksize, int blockSize, long r) {
        this.keySize = ksize;
        this.m = (blockSize - 4 + ksize) / (ksize + 8);
        if (this.m < 3) {
            throw new IllegalArgumentException("Block size is too small, must have space for at least 3 children");
        }
        this.nodeSize = this.m * (ksize + 8) - ksize + 4;
        this.minKeys = (this.m & 2) == 0 ? (this.m >> 1) - 1 : this.m >> 1;
        this.doRandom = (this.m & 2) == 0;
        this.nodeCache = new HashMap<Long, BTreeNode>();
        this.unusedNodes = new LinkedHashMap<Long, BTreeNode>(16, 0.75f, true);
        this.modifiedNodes = new LinkedHashSet<BTreeNode>();
        this.root = r;
    }

    public void sync() throws IOException {
        while (!this.modifiedNodes.isEmpty()) {
            this.modifiedNodes.iterator().next().flush();
        }
    }

    public byte[] removeGreaterOrEqual(byte[] key) throws IOException {
        Assert.isLegal((key.length == this.keySize ? 1 : 0) != 0);
        if (this.root == -1L) {
            return null;
        }
        BTreeNode node = this.getNode(null, this.root);
        BTreeNode nextSearchNode = null;
        int removeIdx = -1;
        int idx;
        while ((idx = node.findInNode(key)) < 0) {
            idx = -(idx + 1);
            long child = node.getChild(idx);
            if (idx < node.getSize()) {
                nextSearchNode = node;
                removeIdx = idx;
            }
            if (child == -1L) {
                return this.removeNextKey(nextSearchNode, removeIdx);
            }
            node = this.getNode(node, child);
        }
        return this.removeKey(node, idx);
    }

    protected byte[] removeNextKey(BTreeNode node, int idx) throws IOException {
        if (node == null) {
            return null;
        }
        return this.removeKey(node, idx);
    }

    protected byte[] removeKey(BTreeNode node, int idx) throws IOException {
        byte[] removed = node.getKey(idx);
        BTreeNode suc = this.findSuccessor(node, idx);
        if (suc != null) {
            byte[] key = suc.getKey(0);
            node.replace(key, idx);
            node = suc;
            idx = 0;
        }
        while (true) {
            BTreeNode parent = node.getParent();
            idx = node.remove(idx);
            if (parent == null) {
                if (node.getSize() == 0) {
                    long onlyChild = node.getChild(0);
                    BTreeNode oldRoot = node;
                    if (onlyChild != -1L) {
                        this.root = onlyChild;
                        node = this.getCachedNode(onlyChild);
                        if (node != null) {
                            node.setParent(null);
                        }
                    } else {
                        this.root = -1L;
                    }
                    this.freeNode(oldRoot);
                }
                return removed;
            }
            if (idx == -1) {
                return removed;
            }
            node = parent;
        }
    }

    protected BTreeNode findSuccessor(BTreeNode node, int idx) throws IOException {
        long child = node.getChild(idx + 1);
        if (child == -1L) {
            return null;
        }
        while ((child = (node = this.getNode(node, child)).getChild(0)) != -1L) {
        }
        return node;
    }

    public void insert(byte[] key) throws IOException {
        Assert.isLegal((key.length == this.keySize ? 1 : 0) != 0);
        if (this.root == -1L) {
            byte[] keys = new byte[(this.m - 1) * this.keySize];
            long[] values = new long[this.m];
            System.arraycopy(key, 0, keys, 0, this.keySize);
            int i = 0;
            while (i < this.m) {
                values[i] = -1L;
                ++i;
            }
            BTreeNode rootNode = this.createNewNode(null, 1, keys, 0, values);
            this.root = rootNode.getOffset();
            return;
        }
        BTreeNode node = this.getNode(null, this.root);
        int idx;
        while ((idx = node.findInNode(key)) < 0) {
            long child = node.getChild(idx = -(idx + 1));
            if (child == -1L) {
                this.insertIntoNode(node, key, idx);
                return;
            }
            node = this.getNode(node, child);
        }
        return;
    }

    protected void insertIntoNode(BTreeNode node, byte[] key, int idx) throws IOException {
        long rightChild = -1L;
        while (true) {
            if (node.getSize() < this.m - 1) {
                node.insert(key, idx, rightChild);
                return;
            }
            SplitData s = node.split(key, idx, rightChild);
            if ((node = node.getParent()) == null) {
                byte[] keys = new byte[(this.m - 1) * this.keySize];
                System.arraycopy(s.parentKey, 0, keys, 0, this.keySize);
                long[] children = new long[this.m];
                children[0] = s.leftChild;
                children[1] = s.rightChild;
                int i = 2;
                while (i < this.m) {
                    children[i] = -1L;
                    ++i;
                }
                BTreeNode newRootNode = this.createNewNode(null, 1, keys, 2, children);
                this.root = newRootNode.getOffset();
                return;
            }
            key = s.parentKey;
            idx = node.findInNode(key);
            Assert.isTrue((idx < 0 ? 1 : 0) != 0);
            idx = -(idx + 1);
            rightChild = s.rightChild;
        }
    }

    protected BTreeNode getCachedNode(long offset) {
        BTreeNode node = this.unusedNodes.get(offset);
        if (node == null) {
            return this.nodeCache.get(offset);
        }
        return node;
    }

    protected BTreeNode getNode(BTreeNode parent, long offset) throws IOException {
        BTreeNode node = this.getCachedNode(offset);
        if (node != null) {
            return node;
        }
        node = new BTreeNode(parent, offset);
        this.addNodeToCache(node);
        return node;
    }

    protected BTreeNode createNewNode(BTreeNode parent, int numKeys, byte[] keys, int numChildren, long[] children) throws IOException {
        long offset = this.allocateNode();
        BTreeNode node = new BTreeNode(parent, offset, numKeys, keys, numChildren, children);
        this.addNodeToCache(node);
        return node;
    }

    protected void addNodeToCache(BTreeNode node) throws IOException {
        if (this.nodeCache.size() >= this.maxCacheSize) {
            BTreeNode removed = this.unusedNodes.values().iterator().next();
            removed.flush();
            this.nodeCache.remove(removed.getOffset());
        }
        this.nodeCache.put(node.getOffset(), node);
        if (!node.isReferenced()) {
            this.unusedNodes.put(node.getOffset(), node);
        }
    }

    protected long allocateNode() throws IOException {
        return this.allocator.allocateNode(this.nodeSize);
    }

    protected void freeNode(BTreeNode node) throws IOException {
        long offset = node.getOffset();
        this.nodeCache.remove(offset);
        this.modifiedNodes.remove(node);
        this.unusedNodes.remove(offset);
        node.free();
        this.allocator.freeNode(offset);
    }

    protected void writeFully(ByteBuffer buf, long position) throws IOException {
        FileChannelUtil.writeFully(buf, position, this.raf, false);
    }

    protected void readFully(ByteBuffer buf, long position) throws IOException {
        FileChannelUtil.readFully(buf, position, this.raf, false);
    }

    protected class BTreeNode {
        protected long offset;
        protected int numKeys;
        protected int numChildren;
        protected byte[] keys;
        protected long[] children;
        protected BTreeNode parent;
        protected int refCount;
        protected boolean modified;

        protected BTreeNode(BTreeNode parent, long offset, boolean ignore) {
            this.offset = offset;
            this.parent = parent;
            if (parent != null) {
                parent.referenced();
            }
        }

        public BTreeNode(BTreeNode parent, long offset) throws IOException {
            this(parent, offset, true);
            this.readNode();
        }

        public BTreeNode(BTreeNode parent, long offset, int numKeys, byte[] keys, int numChildren, long[] children) {
            Assert.isTrue((children.length == BTree.this.m ? 1 : 0) != 0);
            Assert.isTrue((keys.length == (BTree.this.m - 1) * BTree.this.keySize ? 1 : 0) != 0);
            Assert.isTrue((numChildren == 0 || numChildren == numKeys + 1 ? 1 : 0) != 0);
            Assert.isTrue((parent == null || numKeys >= BTree.this.minKeys ? 1 : 0) != 0);
            this.offset = offset;
            this.numKeys = numKeys;
            this.keys = keys;
            this.numChildren = numChildren;
            this.children = children;
            this.parent = parent;
            if (parent != null) {
                parent.referenced();
            }
            this.markModified();
            int i = 0;
            while (i < numChildren) {
                this.becomeParentOf(children[i]);
                ++i;
            }
        }

        protected void becomeParentOf(long child) {
            BTreeNode node = BTree.this.getCachedNode(child);
            if (node != null) {
                node.setParent(this);
            }
        }

        protected void markModified() {
            this.modified = true;
            BTree.this.modifiedNodes.add(this);
        }

        protected void markClean() {
            this.modified = false;
            BTree.this.modifiedNodes.remove(this);
        }

        protected void referenced() {
            if (this.refCount == 0) {
                BTree.this.unusedNodes.remove(this.offset);
            }
            ++this.refCount;
        }

        public boolean isReferenced() {
            return this.refCount != 0;
        }

        protected void release() {
            Assert.isTrue((this.refCount > 0 ? 1 : 0) != 0);
            --this.refCount;
            if (this.refCount == 0) {
                BTree.this.unusedNodes.put(this.offset, this);
            }
        }

        protected void readNode() throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(BTree.this.nodeSize);
            BTree.this.readFully(buf, this.offset);
            buf.rewind();
            this.numKeys = buf.getInt();
            this.keys = new byte[(BTree.this.m - 1) * BTree.this.keySize];
            buf.get(this.keys);
            this.children = new long[BTree.this.m];
            this.numChildren = 0;
            while (this.numChildren < BTree.this.m) {
                long child;
                this.children[this.numChildren] = child = buf.getLong();
                if (child == -1L) {
                    int i = this.numChildren + 1;
                    while (i < BTree.this.m) {
                        this.children[i] = -1L;
                        ++i;
                    }
                    break;
                }
                ++this.numChildren;
            }
            this.markClean();
            Assert.isTrue((this.numChildren == 0 || this.numChildren == this.numKeys + 1 ? 1 : 0) != 0);
        }

        public void flush() throws IOException {
            if (this.modified) {
                this.writeNode();
            }
        }

        protected void writeNode() throws IOException {
            ByteBuffer buf = ByteBuffer.allocate(BTree.this.nodeSize);
            buf.putInt(this.numKeys);
            buf.put(this.keys);
            int i = 0;
            while (i < BTree.this.m) {
                buf.putLong(this.children[i]);
                ++i;
            }
            buf.rewind();
            BTree.this.writeFully(buf, this.offset);
            this.markClean();
        }

        public int findInNode(byte[] key) {
            Assert.isTrue((key.length == BTree.this.keySize ? 1 : 0) != 0);
            int top = this.numKeys;
            int bottom = 0;
            while (top != bottom) {
                int middle = top + bottom >>> 1;
                int result = BTree.this.cmp.compare(key, this.keys, middle * BTree.this.keySize);
                if (result == 0) {
                    return middle;
                }
                if (result > 0) {
                    bottom = middle + 1;
                    continue;
                }
                top = middle;
            }
            return -(bottom + 1);
        }

        public void insert(byte[] key, int idx, long rightChild) {
            Assert.isTrue((this.numChildren == 0 || rightChild != -1L ? 1 : 0) != 0);
            Assert.isTrue((this.numKeys < BTree.this.m - 1 ? 1 : 0) != 0);
            Assert.isTrue((idx >= 0 && idx <= this.numKeys ? 1 : 0) != 0);
            int startPos = idx * BTree.this.keySize;
            if (this.numKeys != idx) {
                int len = this.numKeys * BTree.this.keySize - startPos;
                System.arraycopy(this.keys, startPos, this.keys, startPos + BTree.this.keySize, len);
            }
            System.arraycopy(key, 0, this.keys, startPos, BTree.this.keySize);
            ++this.numKeys;
            if (this.numChildren != 0) {
                int start = idx + 1;
                System.arraycopy(this.children, start, this.children, idx + 2, this.numChildren - start);
                this.children[start] = rightChild;
                this.becomeParentOf(rightChild);
                ++this.numChildren;
            }
            this.markModified();
        }

        public void replace(byte[] key, int idx) {
            System.arraycopy(key, 0, this.keys, idx * BTree.this.keySize, BTree.this.keySize);
            this.markModified();
        }

        public long getChild(int idx) {
            if (idx >= this.numChildren) {
                Assert.isTrue((this.numChildren == 0 ? 1 : 0) != 0);
                return -1L;
            }
            return this.children[idx];
        }

        public byte[] getKey(int idx) {
            Assert.isTrue((idx < this.numKeys ? 1 : 0) != 0);
            byte[] result = new byte[BTree.this.keySize];
            System.arraycopy(this.keys, idx * BTree.this.keySize, result, 0, BTree.this.keySize);
            return result;
        }

        public BTreeNode getParent() {
            return this.parent;
        }

        public void setParent(BTreeNode newParent) {
            if (this.parent != null) {
                this.parent.release();
            }
            this.parent = newParent;
            if (this.parent != null) {
                this.parent.referenced();
            }
        }

        public long getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.numKeys;
        }

        public SplitData split(byte[] newKey, int idx, long rightChild) throws IOException {
            int i;
            int startIdx;
            int numSiblingChildren;
            Assert.isTrue((this.numKeys == BTree.this.m - 1 ? 1 : 0) != 0);
            int middle = BTree.this.m >> 1;
            if (BTree.this.doRandom && BTree.this.rnd.nextBoolean()) {
                --middle;
            }
            byte[] parentKey = new byte[BTree.this.keySize];
            byte[] siblingKeys = new byte[this.keys.length];
            long[] siblingChildren = new long[BTree.this.m];
            this.numKeys = middle;
            if (this.numChildren != 0) {
                Assert.isTrue((this.numChildren == BTree.this.m ? 1 : 0) != 0);
                this.numChildren = this.numKeys + 1;
                numSiblingChildren = BTree.this.m + 1 - this.numChildren;
            } else {
                numSiblingChildren = 0;
            }
            if (idx == middle) {
                startIdx = middle * BTree.this.keySize;
                System.arraycopy(this.keys, startIdx, siblingKeys, 0, this.keys.length - startIdx);
                System.arraycopy(newKey, 0, parentKey, 0, BTree.this.keySize);
                if (this.numChildren != 0) {
                    siblingChildren[0] = rightChild;
                    System.arraycopy(this.children, this.numChildren, siblingChildren, 1, BTree.this.m - this.numChildren);
                }
            } else if (idx > middle) {
                startIdx = (middle + 1) * BTree.this.keySize;
                int endIdx = idx * BTree.this.keySize;
                int len = endIdx - startIdx;
                System.arraycopy(this.keys, startIdx, siblingKeys, 0, len);
                System.arraycopy(newKey, 0, siblingKeys, len, BTree.this.keySize);
                System.arraycopy(this.keys, startIdx - BTree.this.keySize, parentKey, 0, BTree.this.keySize);
                System.arraycopy(this.keys, endIdx, siblingKeys, len + BTree.this.keySize, this.keys.length - endIdx);
                if (this.numChildren != 0) {
                    endIdx = idx + 1;
                    len = endIdx - this.numChildren;
                    System.arraycopy(this.children, this.numChildren, siblingChildren, 0, len);
                    siblingChildren[len] = rightChild;
                    System.arraycopy(this.children, endIdx, siblingChildren, len + 1, BTree.this.m - endIdx);
                }
            } else {
                startIdx = middle * BTree.this.keySize;
                System.arraycopy(this.keys, startIdx - BTree.this.keySize, parentKey, 0, BTree.this.keySize);
                System.arraycopy(this.keys, startIdx, siblingKeys, 0, this.keys.length - startIdx);
                int startIdx2 = idx * BTree.this.keySize;
                int startIdx3 = startIdx2 + BTree.this.keySize;
                System.arraycopy(this.keys, startIdx2, this.keys, startIdx3, startIdx - startIdx3);
                System.arraycopy(newKey, 0, this.keys, startIdx2, BTree.this.keySize);
                if (this.numChildren != 0) {
                    System.arraycopy(this.children, this.numKeys, siblingChildren, 0, BTree.this.m - this.numKeys);
                    startIdx = idx + 1;
                    startIdx2 = idx + 2;
                    System.arraycopy(this.children, startIdx, this.children, startIdx2, this.numChildren - startIdx2);
                    this.children[startIdx] = rightChild;
                    this.becomeParentOf(rightChild);
                }
            }
            if (this.numChildren != 0) {
                i = this.numChildren;
                while (i < BTree.this.m) {
                    this.children[i] = -1L;
                    ++i;
                }
                i = numSiblingChildren;
                while (i < BTree.this.m) {
                    siblingChildren[i] = -1L;
                    ++i;
                }
            } else {
                i = 0;
                while (i < BTree.this.m) {
                    siblingChildren[i] = -1L;
                    ++i;
                }
            }
            BTreeNode newNode = BTree.this.createNewNode(this.parent, BTree.this.m - this.numKeys - 1, siblingKeys, numSiblingChildren, siblingChildren);
            this.markModified();
            return new SplitData(parentKey, this.offset, newNode.offset);
        }

        protected void doRemove(int idx, boolean keepRight) {
            int start = (idx + 1) * BTree.this.keySize;
            int end = this.numKeys * BTree.this.keySize;
            System.arraycopy(this.keys, start, this.keys, start - BTree.this.keySize, end - start);
            --this.numKeys;
            if (this.numChildren != 0) {
                if (keepRight) {
                    start = idx + 1;
                    System.arraycopy(this.children, start, this.children, idx, this.numChildren - start);
                } else {
                    start = idx + 2;
                    System.arraycopy(this.children, start, this.children, idx + 1, this.numChildren - start);
                }
                --this.numChildren;
                this.children[this.numChildren] = -1L;
            }
            this.markModified();
        }

        public int remove(int idx) throws IOException {
            Assert.isTrue((idx < this.numKeys ? 1 : 0) != 0);
            if (this.parent == null || this.numKeys > BTree.this.minKeys) {
                this.doRemove(idx, false);
                return -1;
            }
            int parentIdx = this.parent.findInNode(this.getKey(0));
            parentIdx = parentIdx >= 0 ? ++parentIdx : -(parentIdx + 1);
            Assert.isTrue((this.parent.getChild(parentIdx) == this.offset ? 1 : 0) != 0);
            if (BTree.this.rnd.nextBoolean()) {
                if (this.borrowFromRight(idx, parentIdx)) {
                    return -1;
                }
                if (this.borrowFromLeft(idx, parentIdx)) {
                    return -1;
                }
                return this.mergeWithRight(idx, parentIdx);
            }
            if (this.borrowFromLeft(idx, parentIdx)) {
                return -1;
            }
            if (this.borrowFromRight(idx, parentIdx)) {
                return -1;
            }
            return this.mergeWithLeft(idx, parentIdx);
        }

        protected int mergeWithRight(int idx, int parentIdx) throws IOException {
            if (this.parent.getSize() <= parentIdx) {
                return this.mergeWithLeft(idx, parentIdx);
            }
            int start = (idx + 1) * BTree.this.keySize;
            int end = this.numKeys * BTree.this.keySize;
            System.arraycopy(this.keys, start, this.keys, start - BTree.this.keySize, end - start);
            --this.numKeys;
            if (this.numChildren != 0) {
                start = idx + 2;
                System.arraycopy(this.children, start, this.children, idx + 1, this.numChildren - start);
                --this.numChildren;
                this.children[this.numChildren] = -1L;
            }
            return this.mergeWithRight(parentIdx);
        }

        protected int mergeWithRight(int parentIdx) throws IOException {
            byte[] parentKey = this.parent.getKey(parentIdx);
            int end = this.numKeys * BTree.this.keySize;
            System.arraycopy(parentKey, 0, this.keys, end, BTree.this.keySize);
            BTreeNode right = BTree.this.getNode(this.parent, this.parent.getChild(parentIdx + 1));
            System.arraycopy(right.keys, 0, this.keys, end + BTree.this.keySize, right.numKeys * BTree.this.keySize);
            this.numKeys += 1 + right.numKeys;
            if (this.numChildren != 0) {
                System.arraycopy(right.children, 0, this.children, this.numChildren, right.numChildren);
                this.numChildren += right.numChildren;
                int i = 0;
                while (i < right.numChildren) {
                    this.becomeParentOf(right.children[i]);
                    ++i;
                }
            }
            BTree.this.freeNode(right);
            this.markModified();
            return parentIdx;
        }

        protected int mergeWithLeft(int idx, int parentIdx) throws IOException {
            if (parentIdx == 0) {
                return this.mergeWithRight(idx, parentIdx);
            }
            BTreeNode left = BTree.this.getNode(this.parent, this.parent.getChild(parentIdx - 1));
            int start = (idx + 1) * BTree.this.keySize;
            int end = this.numKeys * BTree.this.keySize;
            System.arraycopy(this.keys, start, this.keys, start - BTree.this.keySize, end - start);
            --this.numKeys;
            if (this.numChildren != 0) {
                start = idx + 2;
                System.arraycopy(this.children, start, this.children, idx + 1, this.numChildren - start);
                --this.numChildren;
                this.children[this.numChildren] = -1L;
            }
            return left.mergeWithRight(parentIdx - 1);
        }

        protected boolean borrowFromRight(int idx, int parentIdx) throws IOException {
            if (this.parent.getSize() <= parentIdx) {
                return false;
            }
            BTreeNode right = BTree.this.getNode(this.parent, this.parent.getChild(parentIdx + 1));
            if (right.getSize() == BTree.this.minKeys) {
                return false;
            }
            byte[] removed = right.getKey(0);
            long leftChild = right.getChild(0);
            right.doRemove(0, true);
            byte[] parentKey = this.parent.getKey(parentIdx);
            this.parent.replace(removed, parentIdx);
            this.doRemove(idx, false);
            System.arraycopy(parentKey, 0, this.keys, this.numKeys * BTree.this.keySize, BTree.this.keySize);
            ++this.numKeys;
            if (leftChild != -1L) {
                this.children[this.numChildren] = leftChild;
                ++this.numChildren;
                this.becomeParentOf(leftChild);
            }
            this.markModified();
            return true;
        }

        protected boolean borrowFromLeft(int idx, int parentIdx) throws IOException {
            if (parentIdx == 0) {
                return false;
            }
            BTreeNode left = BTree.this.getNode(this.parent, this.parent.getChild(parentIdx - 1));
            if (left.getSize() == BTree.this.minKeys) {
                return false;
            }
            byte[] removed = left.getKey(left.getSize() - 1);
            long rightChild = left.getChild(left.getSize());
            left.doRemove(left.getSize() - 1, false);
            byte[] parentKey = this.parent.getKey(parentIdx - 1);
            this.parent.replace(removed, parentIdx - 1);
            System.arraycopy(this.keys, 0, this.keys, BTree.this.keySize, idx * BTree.this.keySize);
            System.arraycopy(parentKey, 0, this.keys, 0, BTree.this.keySize);
            if (rightChild != -1L) {
                System.arraycopy(this.children, 0, this.children, 1, idx + 1);
                this.children[0] = rightChild;
                this.becomeParentOf(rightChild);
            }
            this.markModified();
            return true;
        }

        public void free() {
            this.markClean();
            this.setParent(null);
            this.offset = -1L;
        }
    }

    protected static class SplitData {
        protected byte[] parentKey;
        protected long leftChild;
        protected long rightChild;

        public SplitData(byte[] parentKey, long leftChild, long rightChild) {
            this.parentKey = parentKey;
            this.leftChild = leftChild;
            this.rightChild = rightChild;
        }
    }
}

