/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate;

import com.urbancode.commons.util.Check;
import com.urbancode.persistence.hibernate.TxManager;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionLocal<T> {
    private final TxManager txman;

    public SessionLocal(TxManager txman) {
        Check.nonNull((Object)txman);
        this.txman = txman;
    }

    public T get() {
        TxManager.TxState state = this.txman.getTxState();
        if (state == null || !state.isSessionLocalStorageActive()) {
            throw new RuntimeException("Session locals unavailable");
        }
        Map<SessionLocal<?>, Object> map = state.initSessionLocalMap();
        if (map.containsKey(this)) {
            return (T)map.get(this);
        }
        T value = this.initialValue();
        map.put(this, value);
        return value;
    }

    public void set(T value) {
        TxManager.TxState state = this.txman.getTxState();
        if (state == null || !state.isSessionLocalStorageActive()) {
            throw new RuntimeException("Session locals unavailable");
        }
        Map<SessionLocal<?>, Object> map = state.initSessionLocalMap();
        map.put(this, value);
    }

    public void remove() {
        TxManager.TxState state = this.txman.getTxState();
        if (state == null || !state.isSessionLocalStorageActive()) {
            throw new RuntimeException("Session locals unavailable");
        }
        Map<SessionLocal<?>, Object> map = state.getSessionLocalMap();
        if (map != null) {
            map.remove(this);
        }
    }

    protected TxManager getTxManager() {
        return this.txman;
    }

    protected T initialValue() {
        return null;
    }
}

