/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.enumeration;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IEnumerationClient;
import com.ibm.team.workitem.client.internal.ClientServiceContext;
import com.ibm.team.workitem.common.internal.ICommonServiceContext;
import com.ibm.team.workitem.common.internal.IEnumerationService;
import com.ibm.team.workitem.common.internal.ServiceRunnable;
import com.ibm.team.workitem.common.internal.enumeration.Enumeration;
import com.ibm.team.workitem.common.internal.enumeration.EnumerationHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public class EnumerationClient
implements IEnumerationClient {
    private final ICommonServiceContext fContext;

    public EnumerationClient(IClientLibraryContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        this.fContext = new ClientServiceContext(context);
    }

    public IEnumerationService getService() throws TeamRepositoryException {
        IEnumerationService service = (IEnumerationService)this.fContext.getService(IEnumerationService.class);
        if (service == null) {
            throw new TeamRepositoryException("Unable to get IEnumerationService");
        }
        return service;
    }

    @Override
    public Enumeration[] resolveEnumerations(final IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable runnable = new ServiceRunnable(){

            public Enumeration[] run() throws TeamRepositoryException {
                return EnumerationClient.this.getService().resolveEnumerations(projectArea);
            }
        };
        return (Enumeration[])this.fContext.callCancelableService(runnable, monitor);
    }

    @Override
    public void save(final Enumeration enumeration, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable runnable = new ServiceRunnable(){

            public Object run() throws TeamRepositoryException {
                EnumerationClient.this.getService().save(enumeration);
                return null;
            }
        };
        this.fContext.callCancelableService(runnable, monitor);
    }

    @Override
    public void delete(final EnumerationHandle enumeration, IProgressMonitor monitor) throws TeamRepositoryException {
        ServiceRunnable runnable = new ServiceRunnable(){

            public Object run() throws TeamRepositoryException {
                EnumerationClient.this.getService().delete(enumeration);
                return null;
            }
        };
        this.fContext.callCancelableService(runnable, monitor);
    }
}

