/**
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2007, 2009. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *
 * $Id$
 */
package com.ibm.team.foundation.rcp.core.internal.favorites.impl;

import java.net.URI;
import java.net.URISyntaxException;

import com.ibm.team.foundation.rcp.core.internal.FoundationRCPCorePlugin;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesPackage;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>URI Favorite</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.URIFavoriteImpl#getDetails <em>Details</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.URIFavoriteImpl#getFavoriteType <em>Favorite Type</em>}</li>
 *   <li>{@link com.ibm.team.foundation.rcp.core.internal.favorites.impl.URIFavoriteImpl#getUri <em>Uri</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class URIFavoriteImpl extends FavoritesNodeImpl implements URIFavorite {
	/**
	 * The default value of the '{@link #getDetails() <em>Details</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDetails()
	 * @generated
	 * @ordered
	 */
	protected static final String DETAILS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDetails() <em>Details</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDetails()
	 * @generated
	 * @ordered
	 */
	protected String details = DETAILS_EDEFAULT;

	/**
	 * The flag representing whether the Details attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final int DETAILS_ESETFLAG = 1 << 3;

	/**
	 * The default value of the '{@link #getFavoriteType() <em>Favorite Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFavoriteType()
	 * @generated
	 * @ordered
	 */
	protected static final String FAVORITE_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFavoriteType() <em>Favorite Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFavoriteType()
	 * @generated
	 * @ordered
	 */
	protected String favoriteType = FAVORITE_TYPE_EDEFAULT;

	/**
	 * The flag representing whether the Favorite Type attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final int FAVORITE_TYPE_ESETFLAG = 1 << 4;

	/**
	 * The default value of the '{@link #getUri() <em>Uri</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUri()
	 * @generated
	 * @ordered
	 */
	protected static final String URI_EDEFAULT = ""; //$NON-NLS-1$

	/**
	 * The cached value of the '{@link #getUri() <em>Uri</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUri()
	 * @generated
	 * @ordered
	 */
	protected String uri = URI_EDEFAULT;

	/**
	 * The flag representing whether the Uri attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final int URI_ESETFLAG = 1 << 5;

	private Object fResolvedObject;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected URIFavoriteImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return FavoritesPackage.Literals.URI_FAVORITE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDetails() {
		return details;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDetails(String newDetails) {
		String oldDetails = details;
		details = newDetails;
		boolean oldDetailsESet = (ALL_FLAGS & DETAILS_ESETFLAG) != 0;
		ALL_FLAGS |= DETAILS_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					FavoritesPackage.URI_FAVORITE__DETAILS, oldDetails,
					details, !oldDetailsESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetDetails() {
		String oldDetails = details;
		boolean oldDetailsESet = (ALL_FLAGS & DETAILS_ESETFLAG) != 0;
		details = DETAILS_EDEFAULT;
		ALL_FLAGS &= ~DETAILS_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					FavoritesPackage.URI_FAVORITE__DETAILS, oldDetails,
					DETAILS_EDEFAULT, oldDetailsESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetDetails() {
		return (ALL_FLAGS & DETAILS_ESETFLAG) != 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getFavoriteType() {
		return favoriteType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFavoriteType(String newFavoriteType) {
		String oldFavoriteType = favoriteType;
		favoriteType = newFavoriteType;
		boolean oldFavoriteTypeESet = (ALL_FLAGS & FAVORITE_TYPE_ESETFLAG) != 0;
		ALL_FLAGS |= FAVORITE_TYPE_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					FavoritesPackage.URI_FAVORITE__FAVORITE_TYPE,
					oldFavoriteType, favoriteType, !oldFavoriteTypeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetFavoriteType() {
		String oldFavoriteType = favoriteType;
		boolean oldFavoriteTypeESet = (ALL_FLAGS & FAVORITE_TYPE_ESETFLAG) != 0;
		favoriteType = FAVORITE_TYPE_EDEFAULT;
		ALL_FLAGS &= ~FAVORITE_TYPE_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					FavoritesPackage.URI_FAVORITE__FAVORITE_TYPE,
					oldFavoriteType, FAVORITE_TYPE_EDEFAULT,
					oldFavoriteTypeESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetFavoriteType() {
		return (ALL_FLAGS & FAVORITE_TYPE_ESETFLAG) != 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getUri() {
		return uri;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUri(String newUri) {
		String oldUri = uri;
		uri = newUri;
		boolean oldUriESet = (ALL_FLAGS & URI_ESETFLAG) != 0;
		ALL_FLAGS |= URI_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					FavoritesPackage.URI_FAVORITE__URI, oldUri, uri,
					!oldUriESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetUri() {
		String oldUri = uri;
		boolean oldUriESet = (ALL_FLAGS & URI_ESETFLAG) != 0;
		uri = URI_EDEFAULT;
		ALL_FLAGS &= ~URI_ESETFLAG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET,
					FavoritesPackage.URI_FAVORITE__URI, oldUri, URI_EDEFAULT,
					oldUriESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetUri() {
		return (ALL_FLAGS & URI_ESETFLAG) != 0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case FavoritesPackage.URI_FAVORITE__DETAILS:
			return getDetails();
		case FavoritesPackage.URI_FAVORITE__FAVORITE_TYPE:
			return getFavoriteType();
		case FavoritesPackage.URI_FAVORITE__URI:
			return getUri();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case FavoritesPackage.URI_FAVORITE__DETAILS:
			setDetails((String) newValue);
			return;
		case FavoritesPackage.URI_FAVORITE__FAVORITE_TYPE:
			setFavoriteType((String) newValue);
			return;
		case FavoritesPackage.URI_FAVORITE__URI:
			setUri((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(int featureID) {
		switch (featureID) {
		case FavoritesPackage.URI_FAVORITE__DETAILS:
			unsetDetails();
			return;
		case FavoritesPackage.URI_FAVORITE__FAVORITE_TYPE:
			unsetFavoriteType();
			return;
		case FavoritesPackage.URI_FAVORITE__URI:
			unsetUri();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case FavoritesPackage.URI_FAVORITE__DETAILS:
			return isSetDetails();
		case FavoritesPackage.URI_FAVORITE__FAVORITE_TYPE:
			return isSetFavoriteType();
		case FavoritesPackage.URI_FAVORITE__URI:
			return isSetUri();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (details: "); //$NON-NLS-1$
		if ((ALL_FLAGS & DETAILS_ESETFLAG) != 0)
			result.append(details);
		else
			result.append("<unset>"); //$NON-NLS-1$
		result.append(", favoriteType: "); //$NON-NLS-1$
		if ((ALL_FLAGS & FAVORITE_TYPE_ESETFLAG) != 0)
			result.append(favoriteType);
		else
			result.append("<unset>"); //$NON-NLS-1$
		result.append(", uri: "); //$NON-NLS-1$
		if ((ALL_FLAGS & URI_ESETFLAG) != 0)
			result.append(uri);
		else
			result.append("<unset>"); //$NON-NLS-1$
		result.append(')');
		return result.toString();
	}

	public Object getModelInstance() {
		return fResolvedObject;
	}

	public void setResolvedObject(Object resolved) {
		fResolvedObject = resolved;
	}

	public URI uri() {
		try {
			return new URI(getUri());
		} catch (URISyntaxException e) {
			FoundationRCPCorePlugin.getDefault().log(
					"Illegal URI found in Favorite", e); //$NON-NLS-1$
		}
		return null;
	}

} //URIFavoriteImpl
