/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.AuthorizationRealm;
import com.urbancode.release.rest.models.BuiltInAuthenticationRealm;
import com.urbancode.release.rest.models.LdapAuthenticationRealm;
import java.lang.reflect.Type;

public class AuthenticationRealm<T extends AuthenticationRealm>
extends ClientDescribed<T> {
    public static final BuiltInAuthenticationRealm BUILTIN = (BuiltInAuthenticationRealm)new BuiltInAuthenticationRealm().id("00000000-0000-0000-0000-000000000001");
    public Boolean enabled;
    public Integer allowedAttempts;
    public AuthorizationRealm authorizationRealm;
    protected String loginModuleClassName;
    @JsonReadOnly
    public Boolean readOnly;

    public AuthenticationRealm() {
        this.path = "/authenticationRealms/";
        this.enabled = true;
        this.readOnly = false;
        this.loginModuleClassName = null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public AuthenticationRealm<T> setEnabled(Boolean enabled) {
        return this.enabled(enabled);
    }

    public AuthenticationRealm<T> enabled(Boolean enabled) {
        this.handleNull(enabled, "enabled");
        this.enabled = enabled;
        return this;
    }

    public Integer getAllowedAttempts() {
        return this.allowedAttempts;
    }

    public AuthenticationRealm<T> setAllowedAttempts(Integer allowedAttempts) {
        return this.allowedAttempts(allowedAttempts);
    }

    public AuthenticationRealm<T> allowedAttempts(Integer allowedAttempts) {
        this.handleNull(allowedAttempts, "allowedAttempts");
        this.allowedAttempts = allowedAttempts;
        return this;
    }

    public AuthorizationRealm getAuthorizationRealm() {
        return this.authorizationRealm;
    }

    public AuthenticationRealm<T> setAuthorizationRealm(AuthorizationRealm authorizationRealm) {
        return this.authorizationRealm(authorizationRealm);
    }

    public AuthenticationRealm<T> authorizationRealm(AuthorizationRealm authorizationRealm) {
        this.handleNull(authorizationRealm, "authorizationRealm");
        this.authorizationRealm = authorizationRealm;
        return this;
    }

    public String getLoginModuleClassName() {
        return this.loginModuleClassName;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public static class Deserializer
    implements JsonDeserializer<AuthenticationRealm> {
        @Override
        public AuthenticationRealm deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonPrimitive()) {
                return (AuthenticationRealm)new AuthenticationRealm().id(json.getAsString());
            }
            if (json.isJsonObject()) {
                JsonObject jo = json.getAsJsonObject();
                if (jo.has("loginModuleClassName")) {
                    AuthenticationRealmType arType = (AuthenticationRealmType)((Object)context.deserialize(jo.get("loginModuleClassName"), (Type)((Object)AuthenticationRealmType.class)));
                    return (AuthenticationRealm)context.deserialize(jo, arType.clientClass);
                }
                if (jo.has("id")) {
                    return (AuthenticationRealm)new AuthenticationRealm().id(jo.get("id").getAsString());
                }
                throw new IllegalStateException("AuthenticationRealm references must have at least an 'id' property");
            }
            throw new IllegalStateException("AuthenticationRealm references should not receive a JsonArray");
        }
    }

    public static enum AuthenticationRealmType {
        BUILTIN(BuiltInAuthenticationRealm.class),
        LDAP(LdapAuthenticationRealm.class);

        public Class<? extends AuthenticationRealm> clientClass;

        private AuthenticationRealmType(Class<? extends AuthenticationRealm> clientClass) {
            this.clientClass = clientClass;
        }

        public String getTypeString() {
            return ((Object)((Object)this)).getClass().getAnnotation(SerializedName.class).value();
        }

        public AuthenticationRealmType fromTypeString(String typeString) {
            for (AuthenticationRealmType type : AuthenticationRealmType.values()) {
                if (!type.getTypeString().equals(typeString)) continue;
                return type;
            }
            return null;
        }
    }
}

