/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.annotations.SerializedName;
import com.jayway.restassured.RestAssured;
import com.urbancode.release.rest.models.AuthenticationRealm;

public class LdapAuthenticationRealm
extends AuthenticationRealm<LdapAuthenticationRealm> {
    @SerializedName(value="properties/connection-name")
    public String connectionName;
    @SerializedName(value="properties/connection-password")
    public String connectionPassword;
    @SerializedName(value="properties/email-attribute")
    public String emailAttribute;
    @SerializedName(value="properties/name-attribute")
    public String nameAttribute;
    @SerializedName(value="properties/url")
    public String url;
    @SerializedName(value="properties/user-base")
    public String userBase;
    @SerializedName(value="properties/user-search")
    public String userSearch;
    @SerializedName(value="properties/user-search-subtree")
    public String userSearchSubtree;
    @SerializedName(value="properties/context-factory")
    public final String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";

    public LdapAuthenticationRealm() {
        this.loginModuleClassName = "com.urbancode.security.authentication.ldap.LdapLoginModule";
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public LdapAuthenticationRealm setConnectionName(String connectionName) {
        return this.connectionName(connectionName);
    }

    public LdapAuthenticationRealm connectionName(String connectionName) {
        this.handleNull(connectionName, "properties/connection-name");
        this.connectionName = connectionName;
        return this;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public LdapAuthenticationRealm setConnectionPassword(String connectionPassword) {
        return this.connectionPassword(connectionPassword);
    }

    public LdapAuthenticationRealm connectionPassword(String connectionPassword) {
        this.handleNull(connectionPassword, "properties/connection-password");
        this.connectionPassword = connectionPassword;
        return this;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public LdapAuthenticationRealm setEmailAttribute(String emailAttribute) {
        return this.emailAttribute(emailAttribute);
    }

    public LdapAuthenticationRealm emailAttribute(String emailAttribute) {
        this.handleNull(emailAttribute, "properties/email-attribute");
        this.emailAttribute = emailAttribute;
        return this;
    }

    public String getNameAttribute() {
        return this.nameAttribute;
    }

    public LdapAuthenticationRealm setNameAttribute(String nameAttribute) {
        return this.nameAttribute(nameAttribute);
    }

    public LdapAuthenticationRealm nameAttribute(String nameAttribute) {
        this.handleNull(nameAttribute, "properties/name-attribute");
        this.nameAttribute = nameAttribute;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public LdapAuthenticationRealm setUrl(String url) {
        return this.url(url);
    }

    public LdapAuthenticationRealm url(String url) {
        this.handleNull(url, "properties/url");
        this.url = url;
        return this;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public LdapAuthenticationRealm setUserBase(String userBase) {
        return this.userBase(userBase);
    }

    public LdapAuthenticationRealm userBase(String userBase) {
        this.handleNull(userBase, "properties/user-base");
        this.userBase = userBase;
        return this;
    }

    public String getUserSearch() {
        return this.userSearch;
    }

    public LdapAuthenticationRealm setUserSearch(String userSearch) {
        return this.userSearch(userSearch);
    }

    public LdapAuthenticationRealm userSearch(String userSearch) {
        this.handleNull(userSearch, "properties/user-search");
        this.userSearch = userSearch;
        return this;
    }

    public String getUserSearchSubtree() {
        return this.userSearchSubtree;
    }

    public LdapAuthenticationRealm setUserSearchSubtree(String userSearchSubtree) {
        return this.userSearchSubtree(userSearchSubtree);
    }

    public LdapAuthenticationRealm userSearchSubtree(String userSearchSubtree) {
        this.handleNull(userSearchSubtree, "properties/user-search-subtree");
        this.userSearchSubtree = userSearchSubtree;
        return this;
    }

    public String getContextFactory() {
        return "com.sun.jndi.ldap.LdapCtxFactory";
    }

    public void updateCurrentUsers() {
        RestAssured.given().put(this.path(this.id) + "/updateUsers", new Object[0]);
    }

    public void importUsers(String nameQuery) {
        RestAssured.given().put(this.path(this.id) + "/importUsers/" + nameQuery, new Object[0]);
    }

    public void importAllUsers() {
        this.importUsers("*");
    }
}

