/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.ClientNamed;
import com.urbancode.release.rest.framework.Clients;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.framework.QueryParams;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.Change;
import com.urbancode.release.rest.models.Initiative;
import com.urbancode.release.rest.models.Team;
import com.urbancode.release.rest.models.Version;
import com.urbancode.release.rest.models.internal.Exemption;
import com.urbancode.release.rest.models.internal.Lifecycle;
import com.urbancode.release.rest.models.internal.Milestone;
import com.urbancode.release.rest.models.internal.Phase;
import com.urbancode.release.rest.models.internal.PipelineVersions;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;

public class Release
extends ClientDescribed<Release> {
    public static final Release SAMPLE_RELEASE = (Release)new Release().id("00000000-0000-0000-0000-000000000036");
    public Long targetDate;
    public Team team;
    public Lifecycle lifecycleModel;
    @JsonReadOnly
    public Long dateModified;
    @Deprecated
    @JsonReadOnly
    public String hasEdit;
    @Deprecated
    @JsonReadOnly
    public String lifecycleModelName;
    @Deprecated
    @JsonReadOnly
    public String teamName;
    @Deprecated
    @JsonReadOnly
    public Application baseApplication;
    @JsonReadOnly
    public Application[] applications;
    @JsonReadOnly
    public Phase[] phases;
    @JsonReadOnly
    public Exemption[] exemptions;
    @JsonReadOnly
    public Milestone[] milestones;
    @JsonReadOnly
    public ChangeCount totalChanges;

    public Release() {
        this.path = "/releases/";
        this.oldPath = "/release/";
    }

    public Long getTargetDate() {
        return this.targetDate;
    }

    public Release setTargetDate(Long targetDate) {
        return this.targetDate(targetDate);
    }

    public Release targetDate(Long targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    public Team getTeam() {
        return this.team;
    }

    public Release setTeam(Team team) {
        return this.team(team);
    }

    public Release team(Team team) {
        this.handleNull(team, "team");
        this.team = team;
        return this;
    }

    public Lifecycle getLifecycleModel() {
        return this.lifecycleModel;
    }

    public Release setLifecycleModel(Lifecycle lifecycleModel) {
        return this.lifecycleModel(lifecycleModel);
    }

    public Release lifecycleModel(Lifecycle lifecycleModel) {
        this.handleNull(lifecycleModel, "lifecycleModel");
        this.lifecycleModel = lifecycleModel;
        return this;
    }

    public Application[] getApplications() {
        return this.applications;
    }

    public Phase[] getPhases() {
        return this.phases;
    }

    public Exemption[] getExemptions() {
        return this.exemptions;
    }

    public Milestone[] getMilestones() {
        return this.milestones;
    }

    public ChangeCount getTotalChanges() {
        return this.totalChanges;
    }

    @Deprecated
    public String getTeamName() {
        return this.teamName;
    }

    public Application[] getApplicationsRemote(String format) {
        return ((Response)RestAssured.given().queryParam("format", format).get(this.path(this.id) + "/applications", new Object[0])).as(Application[].class, ObjectMapperType.GSON);
    }

    public Release addApplication(Application app) {
        RestAssured.given().post(this.path(this.id) + "/applications/" + app.id, new Object[0]);
        return this;
    }

    public Release addApplications(Application ... apps) {
        return this.addApplications(Release.ids(apps));
    }

    public Release addApplications(String ... applicationIds) {
        RestAssured.given().body((Object)applicationIds, ObjectMapperType.GSON).post(this.path(this.id) + "/applications", new Object[0]);
        return this;
    }

    public Release removeApplication(Application app) {
        RestAssured.given().delete(this.path(this.id) + "/applications/" + app.id, new Object[0]);
        return this;
    }

    public Release removeApplications(Application ... apps) {
        return this.removeApplications(Release.ids(apps));
    }

    public Release removeApplications(String ... applicationIds) {
        RestAssured.given().body((Object)applicationIds, ObjectMapperType.GSON).delete(this.path(this.id) + "/applications", new Object[0]);
        return this;
    }

    public Response updateChanges(Change ... changes) {
        for (Change change : changes) {
            change.release(this);
        }
        return new Change.ChangesUpdate().changes(changes).type(Change.ChangeAssociation.RELEASE).id(this.id).send();
    }

    @Deprecated
    public Change[] getChanges(Application app, Initiative init, String ... types) {
        String typeString = Joiner.on('|').join(types);
        QueryParams query = new QueryParams().param("release", this.id).param("application", app == null ? "NONE" : app.id).param("initiative", init == null ? "NONE" : init.id).param("types", typeString);
        return ((Response)query.apply(RestAssured.given()).get(Clients.change().path() + "impactAnalysis", new Object[0])).as(Change[].class, ObjectMapperType.GSON);
    }

    public Release cloneRelease() {
        log.debug("post() /clone");
        Response response = (Response)RestAssured.given().expect().statusCode(201).when().post(this.path(this.id) + "/clone", new Object[0]);
        log.debug("getting post() response Location");
        String cloneId = response.getHeader("Location");
        cloneId = cloneId.substring(cloneId.lastIndexOf(47) + 1);
        log.debug("retrieved post() response ID:" + this.id);
        return (Release)((Release)Clients.release().id(cloneId)).get();
    }

    @Deprecated
    public Release[] getEditableDropDownList() {
        return ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.oldPath() + "editable", new Object[0])).as(Release[].class, ObjectMapperType.GSON);
    }

    @Deprecated
    public Release[] getIndexList() {
        return ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.oldPath() + "index", new Object[0])).as(Release[].class, ObjectMapperType.GSON);
    }

    public Release getOld() {
        log.debug("getOld()");
        return ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.oldPath(this.id), new Object[0])).as(Release.class, ObjectMapperType.GSON);
    }

    protected String pipelinePath() {
        return "/pipelineView/";
    }

    protected String pipelinePath(String id) {
        return this.pipelinePath() + id;
    }

    @Deprecated
    public PipelineVersions getPipelineVersions() {
        return ((Response)RestAssured.given().get(this.pipelinePath(this.id) + "/allApplicationVersions", new Object[0])).as(PipelineVersions.class, ObjectMapperType.GSON);
    }

    @Deprecated
    public Version getPipelineVersion(Application app, ReleaseEnvironment env) {
        return this.getPipelineVersions().getVersion(app, env);
    }

    public Release defaults() {
        return this.lifecycleModel(Lifecycle.DEFAULT_LIFECYCLE).team(Team.SAMPLE_TEAM);
    }

    public Version getReleaseVersion(String versionName) {
        for (Version version : this.baseApplication.versions) {
            if (!version.name.equals(versionName)) continue;
            return version;
        }
        return null;
    }

    @Deprecated
    public String getApplicationTeamNames() {
        Application[] apps;
        TreeSet<ClientNamed> teams = Sets.newTreeSet(ClientNamed.BY_NAME_IGNORE_CASE);
        for (Application app : apps = this.getApplicationsRemote("detail")) {
            teams.addAll(Arrays.asList(app.teams));
        }
        return Joiner.on(", ").join(Iterables.transform(teams, ClientNamed.GET_NAME));
    }

    public static class ChangeTotal {
        @JsonReadOnly
        public int count;

        public int getCount() {
            return this.count;
        }
    }

    public static class ChangeCount {
        @JsonReadOnly
        public int total;
        @JsonReadOnly
        public Map<String, ChangeTotal> Other;
        @JsonReadOnly
        public Map<String, ChangeTotal> New;
        @JsonReadOnly
        @SerializedName(value="In Progress")
        public Map<String, ChangeTotal> InProgress;
        @JsonReadOnly
        public Map<String, ChangeTotal> Completed;
        @JsonReadOnly
        public Map<String, ChangeTotal> Accepted;

        public int getTotal() {
            return this.total;
        }

        public Map<String, ChangeTotal> getOther() {
            return this.Other;
        }

        public Map<String, ChangeTotal> getNew() {
            return this.New;
        }

        public Map<String, ChangeTotal> getInProgress() {
            return this.InProgress;
        }

        public Map<String, ChangeTotal> getCompleted() {
            return this.Completed;
        }

        public Map<String, ChangeTotal> getAccepted() {
            return this.Accepted;
        }
    }
}

