#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.*

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;

import java.net.URI;

import com.rallydev.rest.RallyRestApi;
import com.rallydev.rest.request.QueryRequest;
import com.rallydev.rest.response.QueryResponse;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;


final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def rallyUrl = props['rallyUrl']
def rallyApiKey = props['rallyApiKey']

def jsonArray = null;

def slurper = new groovy.json.JsonSlurper();

try {
    
    println "URL:"+rallyUrl ;
    
    // Establish a rally client object
    RallyRestApi rallyHelper = new RallyRestApi(new URI(rallyUrl), rallyApiKey);

    // Use a basic testcase query to check the authentication
    QueryRequest defectCount = new QueryRequest("testcase");
    
    // Run this query to determine that all was successful.
    QueryResponse defectCountResponse = rallyHelper.query(defectCount);
    int total = defectCountResponse.getTotalResultCount();
        
    // If we can successfully parse JSON, then we declare a successful connection
    def init = slurper.parseText(defectCountResponse.getResults().toString());

    rallyHelper.close();
    System.out.println("-------------Connection Success-----------");
}
catch (e) {
    println "-------------------------------------------------------------------------------"
    println "Connection Failed"
    println "-------------------------------------------------------------------------------"
    throw new Exception("Error retrieving TestCases <br/>"+e.getMessage());
}