#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.*

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;

import java.net.URI;

import org.apache.http.client.ResponseHandler;
import org.apache.http.impl.client.BasicResponseHandler;
import org.junit.Test;

import com.rallydev.rest.RallyRestApi;
import com.rallydev.rest.request.QueryRequest;
import com.rallydev.rest.util.QueryFilter;
import com.rallydev.rest.response.QueryResponse;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.rallydev.rest.client.HttpClient;
import com.rallydev.rest.request.GetRequest;

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def rallyUrl = props['rallyUrl']
def rallyApiKey = props['rallyApiKey']
def rallyType = props['rallyType']

def jsonArray = null;

def slurper = new groovy.json.JsonSlurper();

class Item { String label; String value }

// Create a Rally client object
RallyRestApi rallyHelper = new RallyRestApi(new URI(rallyUrl), rallyApiKey);

// Create a query for the type definition of the specified entity
QueryRequest defectTypeRequest = new QueryRequest("typedefinition");
defectTypeRequest.setQueryFilter(new QueryFilter("TypePath", "=", rallyType));
QueryResponse queryResponse = rallyHelper.query(defectTypeRequest);

// Get the _ref url for the attributes of this entity
def attUrl = slurper.parseText(queryResponse.getResults().toString())[0].get("Attributes").get("_ref");

// GET on that url
GetRequest getRequest = new GetRequest(attUrl);
// We accept up to 100 fields for each entity
getRequest.addParam("pagesize", "100");

def attributesResult = rallyHelper.get(getRequest).getObject();

def jsonBuilder = new groovy.json.JsonBuilder()
items = [] as List

// For each item in the results put the item name and item's ElementName in the resulting label and value for the dropdown
(attributesResult.get("Results")).each{
    item ->  
    def i = new Item(label:(item.Name).toString().replace("\"", ""), value:(item.ElementName).toString().replace("\"", ""));
    items.add(i);
}

jsonBuilder(items)

// Printing is how we output to the dropdown
print(jsonBuilder.toString())
