#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2015. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.*
import com.rallydev.rest.RallyRestApi
import com.rallydev.rest.request.QueryRequest
import com.rallydev.rest.util.QueryFilter
import com.rallydev.rest.response.QueryResponse
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder
import com.rallydev.rest.client.HttpClient
import com.rallydev.rest.request.GetRequest
import com.rallydev.rest.util.Fetch

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

def rallyUrl = props['rallyUrl']
def rallyApiKey = props['rallyApiKey']
def rallyType = props['rallyType']

String fieldName
def result = []

if (rallyType == "HierarchicalRequirement" || rallyType == "DefectSuite" || rallyType == "Task" ||
rallyType == "Milestone" || rallyType == "Blocker" || rallyType == "Change") {
    fieldName = "" //No Severity field for these types
}
else if (rallyType == "Defect") {
    fieldName = "Severity"
}
else if (rallyType == "TestCase") {
    fieldName = "Risk"
}

RallyRestApi rallyHelper = new RallyRestApi(new URI(rallyUrl), rallyApiKey)

// Request all type defs
QueryRequest defectTypeRequest = new QueryRequest("typedefinition")
defectTypeRequest.setQueryFilter(new QueryFilter("TypePath", "=", rallyType))
QueryResponse queryResponse = rallyHelper.query(defectTypeRequest)

def slurper = new groovy.json.JsonSlurper()
// Get URL for attributes of the WSAPI Type
def attUrl = slurper.parseText(queryResponse.getResults().toString())[0].get("Attributes").get("_ref")

GetRequest getRequest = new GetRequest(attUrl)
getRequest.addParam("pagesize", "100")

// Actually Get Attributes
def attributesResult = rallyHelper.get(getRequest).getObject()

// IMPROVE THIS:
// Get the fieldName field out of the list of attributes
def severityField
(attributesResult.get("Results")).each{ item ->
    if(item.get("Name").getAsString() == fieldName) {severityField = item}

}
// Get the URL to get the allowed values
def sevValuesUrl = severityField.get("AllowedValues").get("_ref").getAsString()

// Run request for allowed values
GetRequest getValuesRequest = new GetRequest(sevValuesUrl)
getValuesRequest.addParam("pagesize", "100")

def valuesResult = rallyHelper.get(getValuesRequest).getObject()

// Print out allowed values
(valuesResult.get("Results")).each{ item ->
    result << item.get("StringValue").getAsString()
}

result.removeAll([""]) //removes blank values from list

class Item { String label; String value }

if (result != null) {
    if (result.size() > 0) {
        def jsonBuilder = new groovy.json.JsonBuilder()
        items = [] as List
        result.each{ key ->
            def item = new Item(label:key, value:key)
            items.add(item)
        }

        jsonBuilder(items)
        //Old versions of UCR will look for the output printed
        print(jsonBuilder.toString())
        //New Version of UCR will look for the property "Output"
        setOutput(apTool, jsonBuilder.toString())
    }
}

def setOutput(AirPluginTool apTool, String value) {
    apTool.setOutputProperty("Output", value)
    apTool.storeOutputProperties()
}
