#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.*

import java.net.URI
import java.net.URL
import java.nio.charset.Charset

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder

import java.net.URI

import org.apache.http.client.ResponseHandler
import org.apache.http.impl.client.BasicResponseHandler
import org.junit.Test

import com.rallydev.rest.RallyRestApi
import com.rallydev.rest.request.QueryRequest
import com.rallydev.rest.util.QueryFilter
import com.rallydev.rest.response.QueryResponse
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder
import com.rallydev.rest.client.HttpClient
import com.rallydev.rest.request.GetRequest

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

def rallyUrl = props['rallyUrl']
def rallyApiKey = props['rallyApiKey']
def rallyType = props['rallyType']

def jsonArray = null

def slurper = new groovy.json.JsonSlurper()


/**
 * This is a general step that allows the user to ping the server and view a piece of sample JSON
 * coming back from the Rally server.  The original implementation required this step significantly
 * more as it required the user to enter the JSON field they wanted to associate to
 * releases/initiatives/apps but now it is really there as another ping for that specific data type.
 * It also shows the potential associated fields.
 */
try {

    println "URL:"+rallyUrl

    RallyRestApi rallyHelper = new RallyRestApi(new URI(rallyUrl), rallyApiKey)

    QueryRequest defectCount = new QueryRequest(rallyType)
    defectCount.setPageSize(1)
    defectCount.setLimit(1)

    println "Query Url:"
    println defectCount.toUrl()


    System.out.println("")
    System.out.println("-------------First Result-----------")
    System.out.println("")

    QueryResponse defectCountResponse = rallyHelper.query(defectCount)

    def errorArray = defectCountResponse.getErrors()
    if(errorArray.length > 0) {
        throw new Exception(errorArray[0])
    }

    int total = defectCountResponse.getTotalResultCount()

    def init = slurper.parseText(defectCountResponse.getResults().toString())

    if( total > 0) {
        println defectCountResponse.getResults().toString().replace("\"", "&quot;")
    }
    else {
        println "No Results"
    }

    System.out.println("")
    System.out.println("-------------Connection Success-----------")

    System.out.println("")
    System.out.println("")

    QueryRequest defectTypeRequest = new QueryRequest("typedefinition")
    defectTypeRequest.setQueryFilter(new QueryFilter("TypePath", "=", rallyType))
    QueryResponse queryResponse = rallyHelper.query(defectTypeRequest)

    System.out.println("")
    System.out.println("")

    def attUrl = slurper.parseText(queryResponse.getResults().toString())[0].get("Attributes").get("_ref")

    GetRequest getRequest = new GetRequest(attUrl)
    getRequest.addParam("pagesize", "100")

    def attributesResult = rallyHelper.get(getRequest).getObject()
    System.out.println("-------------Fields Available for Association-----------")
    (attributesResult.get("Results")).each{ item ->
        println item.get("Name")
    }

    rallyHelper.close()
}
catch (e) {
    println "-------------------------------------------------------------------------------"
    println "Connection Failed"
    println "-------------------------------------------------------------------------------"
    throw new Exception("Error retrieving entities <br/>"+ e.getMessage())
}
