/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.util;

import com.urbancode.commons.util.IO;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class InstalledProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE_NAME = "installed.properties";

    public InstalledProperties() throws IOException {
        this.loadDeafult();
    }

    private void loadDeafult() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream installedProps = cl.getResourceAsStream(RESOURCE_NAME);
        try {
            if (installedProps == null) {
                throw new NullPointerException("Did not find resource installed.properties");
            }
            this.load(installedProps);
        }
        finally {
            IO.close((InputStream)installedProps);
        }
    }

    public Object setProperty(String name, String value) {
        Object result = super.setProperty(name, value);
        try {
            this.storeDefault();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void storeDefault() throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        FileOutputStream installedProps = new FileOutputStream(cl.getResource(RESOURCE_NAME).getPath());
        try {
            this.store(installedProps, "installed properties");
        }
        finally {
            IO.close((OutputStream)installedProps);
        }
    }
}

