/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.CheckpointPlan;
import com.urbancode.release.rest.models.internal.IntegrationProvider;
import com.urbancode.release.rest.models.internal.PropSheetDef;
import com.urbancode.release.rest.models.internal.ReleaseSystem;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.SegmentPlan;
import com.urbancode.release.rest.models.internal.Task;
import com.urbancode.release.rest.models.internal.TaskExecution;
import java.util.List;

public class TaskPlan
extends Task<TaskPlan> {
    public PropSheetDef propSheetDef;
    @JsonReadOnly
    public SegmentPlan segment;
    @JsonReadOnly
    public TaskExecution[] taskExecutions;
    @JsonReadOnly
    public ScheduledDeployment[] completedScheduledDeployments;
    @JsonReadOnly
    public TaskPlan[] prerequisites;
    @JsonReadOnly
    public TaskPlan relatedTask;

    public TaskPlan() {
        this.path = "/taskPlans/";
    }

    public TaskPlan addPrerequisites(TaskPlan ... prerequisites) {
        JsonArray ids = new JsonArray();
        for (TaskPlan prereq : prerequisites) {
            ids.add(new JsonPrimitive(prereq.getId()));
        }
        String json = ids.toString();
        RestAssured.given().body(json).post(this.path(this.id) + "/prerequisites", new Object[0]);
        return (TaskPlan)this.get();
    }

    public TaskPlan removePrerequisites(TaskPlan ... prerequisites) {
        JsonArray ids = new JsonArray();
        for (TaskPlan prereq : prerequisites) {
            ids.add(new JsonPrimitive(prereq.getId()));
        }
        String json = ids.toString();
        RestAssured.given().body(json).delete(this.path(this.id) + "/prerequisites", new Object[0]);
        return (TaskPlan)this.get();
    }

    public TaskPlan addPropSheetDef(PropSheetDef propSheetDef) {
        this.propSheetDef = propSheetDef;
        return this;
    }

    public PropSheetDef getPropSheetDef() {
        return this.propSheetDef;
    }

    public TaskPlan[] sync(List<TaskPlan> toCreateorUpdateorDelete) {
        log.debug("put(many)");
        TaskPlan[] response = (TaskPlan[])((Response)this.query.apply(RestAssured.given()).body(toCreateorUpdateorDelete, ObjectMapperType.GSON).expect().statusCode(200).when().put("/taskPlans/sync", new Object[0])).as(this.arrayClass(), ObjectMapperType.GSON);
        block0: for (int i = 0; i < response.length; ++i) {
            for (TaskPlan item : toCreateorUpdateorDelete) {
                if (!item.externalId.equals(response[i].externalId)) continue;
                toCreateorUpdateorDelete.set(toCreateorUpdateorDelete.indexOf(item), response[i]);
                continue block0;
            }
        }
        return response;
    }

    public TaskPlan[] syncDeleted(IntegrationProvider provider) {
        log.debug("put(many)");
        TaskPlan[] response = (TaskPlan[])((Response)this.query.apply(RestAssured.given()).body((Object)ObjectMapperType.GSON).expect().statusCode(200).when().delete("/taskPlans/syncDeleted/" + provider.getId(), new Object[0])).as(this.arrayClass(), ObjectMapperType.GSON);
        return response;
    }

    @Override
    public TaskPlan findByExternalId(String externalId, String format) {
        return (TaskPlan)((Response)RestAssured.given().queryParam("format", format).expect().contentType(ContentType.JSON).when().get("/taskPlans/externalId/" + externalId, new Object[0])).as(this.modelClass(), ObjectMapperType.GSON);
    }

    public static TaskPlan createSignalOrWaitTask(Task.TaskType type, CheckpointPlan checkpointPlan) {
        String name = "Signal " + checkpointPlan.name;
        if (type == Task.TaskType.WaitTask) {
            name = "Wait for " + checkpointPlan.name;
        }
        return (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)new TaskPlan().name(name)).taskType(type)).checkpointPlan(checkpointPlan)).save();
    }

    public TaskPlan addRelatedTask(TaskPlan relatedTask) {
        RestAssured.given().put(this.path(this.id) + "/relateTo/" + relatedTask.id, new Object[0]);
        return (TaskPlan)this.get();
    }

    public static void createOutageTasks(SegmentPlan beginTaskSegment, SegmentPlan endTaskSegment, ReleaseSystem releaseSystem, int outageWindow) {
        TaskPlan beginTask = new TaskPlan();
        ((TaskPlan)((TaskPlan)((TaskPlan)beginTask.releaseSystem(releaseSystem)).outageMarkerType(Task.OutageMarkerType.BEGIN)).taskType(Task.TaskType.OutageTask)).window(outageWindow);
        TaskPlan endTask = new TaskPlan();
        ((TaskPlan)((TaskPlan)((TaskPlan)endTask.releaseSystem(releaseSystem)).outageMarkerType(Task.OutageMarkerType.END)).taskType(Task.TaskType.OutageTask)).window(outageWindow);
        beginTask.save();
        endTask.save();
        JsonArray json = new JsonArray();
        JsonObject beginTaskJson = new JsonObject();
        beginTaskJson.addProperty("taskId", beginTask.getId());
        beginTaskJson.addProperty("segmentId", beginTaskSegment.getId());
        JsonObject endTaskJson = new JsonObject();
        endTaskJson.addProperty("taskId", endTask.getId());
        endTaskJson.addProperty("segmentId", endTaskSegment.getId());
        json.add(beginTaskJson);
        json.add(endTaskJson);
        RestAssured.given().body((Object)json, ObjectMapperType.GSON).post(beginTaskSegment.path() + "createOutageTasks", new Object[0]);
    }
}

