#!/usr/bin/env groovy
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2020. All Rights Reserved.
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.urelease.rest.Rester;

import groovy.json.JsonSlurper;


final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def deployHostName = props['deployHostName']
def deployToken = props['deployToken']
def rester = new Rester(deployHostName, deployToken);

try {
    def result = rester.getOnUrl("/api/", 0);

	println "IBM UrbanCode Release was able to connect to the following server"
	println deployHostName

	def slurper = new JsonSlurper();
    def resultJson = slurper.parseText(result)
    
	println "AWX REST API current Version: "+resultJson.current_version
    println "Available Version :"+resultJson.available_versions
    
} catch (Exception e) {
    println "Unable to connect to Ansible Tower/."

	def listOfHints =  rester.getHelpOnConnectionException(e);

	listOfHints.each{
		key ->
		println "-"+key;
	}
	println "-----------------------------------------";
    println "Exception:";
	println e;
	println "Cause:";
	println e.cause;
	println "-----------------------------------------";
    throw new RuntimeException();
}