/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientIntegrated;
import java.util.ArrayList;
import java.util.Map;

public class PipelineView
extends ClientIntegrated<PipelineView> {
    public static final String ALL_APPLICATION_VERSIONS = "allApplicationVersions";
    public static final String SHOW_ALL_APPLICATIONS = "showAllApplications";
    public static final String LATEST_APPLICATION_VERSIONS = "latestApplicationVersions";

    public PipelineView() {
        this.path = "/pipelineView/";
    }

    public ArrayList<String> getAllAppIDsWithVerOrChange(String name, String filter) {
        String url = this.path() + name + "/" + ALL_APPLICATION_VERSIONS + "/?" + SHOW_ALL_APPLICATIONS + "=" + filter;
        String rel = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(url, new Object[0])).as(Object.class, ObjectMapperType.GSON).toString();
        ArrayList<String> codes = new ArrayList<String>(10);
        JsonObject result = (JsonObject)new JsonParser().parse(rel);
        for (Map.Entry<String, JsonElement> entry : result.entrySet()) {
            String id = entry.getKey().toString();
            codes.add(id);
        }
        return codes;
    }

    public ArrayList<String> getLatestAppIdsWithVer(String name) {
        String url = this.path() + name + "/" + LATEST_APPLICATION_VERSIONS + "/?" + SHOW_ALL_APPLICATIONS + "=appWithVer";
        String rel = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(url, new Object[0])).asString();
        ArrayList<String> codes = new ArrayList<String>(10);
        JsonParser parser = new JsonParser();
        JsonElement tradeElement = parser.parse(rel);
        JsonArray result = tradeElement.getAsJsonArray();
        for (int i = 0; i < result.size(); ++i) {
            String appID = result.get(i).getAsJsonObject().get("application").getAsJsonObject().get("id").getAsString();
            codes.add(appID);
        }
        return codes;
    }

    public int getLatestAppSizeWithChange(String name) {
        String url = this.path() + name + "/" + LATEST_APPLICATION_VERSIONS + "/?" + SHOW_ALL_APPLICATIONS + "=appWithChange";
        String rel = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(url, new Object[0])).asString();
        JsonParser parser = new JsonParser();
        JsonElement tradeElement = parser.parse(rel);
        JsonArray result = tradeElement.getAsJsonArray();
        return result.size();
    }
}

