/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.unix.ModeParseException;
import com.urbancode.commons.util.unix.UnixPermissions;
import com.urbancode.vfs.common.ClientObject;
import com.urbancode.vfs.common.Hash;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPathEntry
implements ClientObject,
Comparable<ClientPathEntry> {
    private static final Pattern unixPermsPattern = Pattern.compile("([^:]*):([^:]*):([^:]*)");
    private String path;
    private Hash contentHash;
    private FileType type;
    private long length;
    private Long lastModified;
    private String linkPath;
    private Map<Class<?>, Object> permissionMap;
    private List<Hash> additionalHashes = new ArrayList<Hash>();
    private int version;

    public static ClientPathEntry createDirectory(String path, Long lastModified, Set<?> permissionViews) {
        return new ClientPathEntry(path, FileType.DIRECTORY, null, 0L, lastModified, null, permissionViews, null, 1);
    }

    public static ClientPathEntry createFile(String path, Hash hash, long length, Long lastModified, Set<?> permissionViews) {
        return ClientPathEntry.createFile(path, hash, length, lastModified, permissionViews, null);
    }

    public static ClientPathEntry createFile(String path, Hash hash, long length, Long lastModified, Set<?> permissionViews, List<Hash> additionalHashes) {
        return new ClientPathEntry(path, FileType.REGULAR, hash, length, lastModified, null, permissionViews, additionalHashes, 1);
    }

    public static ClientPathEntry createSymlink(String path, String linkPath, Long lastModified, Set<?> permissionViews) {
        return new ClientPathEntry(path, FileType.SYMLINK, null, 0L, lastModified, linkPath, permissionViews, null, 1);
    }

    public static ClientPathEntry[] createPathEntriesFromFileSystem(File baseFile, String[] includes, String[] excludes, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions, FileListerBuilder.Symlinks symlinks, String hashAlgorithm) throws IOException, NoSuchAlgorithmException {
        return ClientPathEntry.createPathEntriesFromFileSystemWithPrefix(baseFile, includes, excludes, null, directories, permissions, symlinks, hashAlgorithm);
    }

    public static ClientPathEntry[] createPathEntriesFromFileSystemWithPrefix(File baseFile, String[] includes, String[] excludes, String pathPrefix, FileListerBuilder.Directories directories, FileListerBuilder.Permissions permissions, FileListerBuilder.Symlinks symlinks, String ... hashAlgorithms) throws IOException, NoSuchAlgorithmException {
        FileListerBuilder builder = new FileListerBuilder(baseFile);
        if (includes != null) {
            builder.include(includes);
        }
        if (excludes != null) {
            builder.exclude(excludes);
        }
        if (!StringUtil.isEmpty((String)pathPrefix)) {
            pathPrefix.replace('\\', '/');
            while (pathPrefix.endsWith("/")) {
                pathPrefix = pathPrefix.substring(0, pathPrefix.length() - 1);
            }
            while (pathPrefix.startsWith("/")) {
                pathPrefix = pathPrefix.substring(1);
            }
        }
        builder.permissions(permissions);
        builder.symlinks(symlinks);
        builder.directories(directories);
        FileLister lister = builder.build();
        List entryList = lister.list();
        ArrayList<ClientPathEntry> pathEntryList = new ArrayList<ClientPathEntry>();
        if (!StringUtil.isEmpty((String)pathPrefix)) {
            pathEntryList.add(ClientPathEntry.createDirectory(pathPrefix, null, null));
        }
        for (TypedFile typedFile : entryList) {
            String path = typedFile.path();
            File file = new File(baseFile, path);
            long length = file.length();
            long lastModified = file.lastModified();
            String linkPath = typedFile.linkPath();
            Set permissionViews = typedFile.permissionViews();
            if (!StringUtil.isEmpty((String)pathPrefix)) {
                path = pathPrefix + "/" + path;
            }
            if (FileType.REGULAR.equals((Object)typedFile.type())) {
                List<Hash> hashes = Hash.hashesForFile(file, hashAlgorithms);
                Hash hash = hashes.remove(0);
                pathEntryList.add(ClientPathEntry.createFile(path, hash, length, lastModified, permissionViews, hashes));
                continue;
            }
            if (FileType.DIRECTORY.equals((Object)typedFile.type())) {
                pathEntryList.add(ClientPathEntry.createDirectory(path, lastModified, permissionViews));
                continue;
            }
            if (!FileType.SYMLINK.equals((Object)typedFile.type())) continue;
            pathEntryList.add(ClientPathEntry.createSymlink(path, linkPath, lastModified, permissionViews));
        }
        return pathEntryList.toArray(new ClientPathEntry[pathEntryList.size()]);
    }

    public static ClientPathEntry fromJSON(JSONObject json) throws JSONException {
        ClientPathEntry entry = null;
        try {
            String path = json.getString("path");
            Hash contentHash = null;
            if (json.has("contentHash")) {
                contentHash = Hash.hashForString(json.getString("contentHash"));
            }
            int version = json.getInt("version");
            FileType type = FileType.valueOf((String)json.getString("type"));
            long length = json.getLong("length");
            Long lastModified = null;
            if (json.has("modified")) {
                lastModified = json.getLong("modified");
            }
            String linkPath = null;
            if (FileType.SYMLINK.equals((Object)type)) {
                linkPath = json.getString("linkPath");
            }
            HashSet<UnixPermissions> permissionViews = null;
            if (json.has("unixPermissions")) {
                permissionViews = new HashSet<UnixPermissions>();
                Matcher matcher = unixPermsPattern.matcher(json.getString("unixPermissions"));
                if (matcher.matches()) {
                    String mode = matcher.group(1);
                    String user = matcher.group(2);
                    String group = matcher.group(3);
                    permissionViews.add(UnixPermissions.createFromOctal((String)mode, (String)user, (String)group));
                }
            }
            ArrayList<Hash> additionalHashes = null;
            if (json.has("additionalHashes")) {
                additionalHashes = new ArrayList<Hash>();
                JSONArray jsonHashes = json.getJSONArray("additionalHashes");
                for (int i = 0; i < jsonHashes.length(); ++i) {
                    additionalHashes.add(Hash.hashForString(jsonHashes.getString(i)));
                }
            }
            entry = new ClientPathEntry(path, type, contentHash, length, lastModified, linkPath, permissionViews, additionalHashes, version);
        }
        catch (ModeParseException e) {
            throw new JSONException("Unable to parse permissions from JSON: " + e.getMessage());
        }
        return entry;
    }

    protected ClientPathEntry(String path, FileType type, Hash contentHash, long length, Long lastModified, String linkPath, Set<?> permissionViews, List<Hash> additionalHashes, int version) {
        this.path = path;
        this.contentHash = contentHash;
        this.type = type;
        this.length = length;
        this.lastModified = lastModified;
        this.linkPath = linkPath;
        this.version = version;
        if (additionalHashes != null) {
            this.additionalHashes.addAll(additionalHashes);
        }
        HashMap map = new HashMap();
        if (permissionViews != null) {
            for (Object permissionView : permissionViews) {
                Class<?> permissionViewClass = permissionView.getClass();
                if (map.containsKey(permissionViewClass)) {
                    throw new IllegalArgumentException("Found multiple instances of the same permission view, " + permissionViewClass + ", for a manifest ");
                }
                map.put(permissionViewClass, permissionView);
            }
        }
        this.permissionMap = Collections.unmodifiableMap(map);
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        String path = this.getPath();
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public Hash getContentHash() {
        return this.contentHash;
    }

    public List<Hash> getAdditionalHashes() {
        return new ArrayList<Hash>(this.additionalHashes);
    }

    public List<Hash> getAllHashes() {
        ArrayList<Hash> hashes = new ArrayList<Hash>();
        if (this.contentHash != null) {
            hashes.add(this.contentHash);
        }
        hashes.addAll(this.additionalHashes);
        return hashes;
    }

    public int getVersion() {
        return this.version;
    }

    public FileType getType() {
        return this.type;
    }

    public long getLength() {
        return this.length;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public String getLinkPath() {
        return this.linkPath;
    }

    public <T> T getPermissionView(Class<T> viewClass) {
        return (T)this.permissionMap.get(viewClass);
    }

    public Set<?> getPermissionViews() {
        return Collections.unmodifiableSet(new HashSet<Object>(this.permissionMap.values()));
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("path", (Object)this.getPath());
        if (this.getContentHash() != null) {
            json.put("contentHash", (Object)this.getContentHash().toString());
        }
        json.put("version", this.getVersion());
        json.put("type", (Object)this.getType().name());
        json.put("length", this.getLength());
        if (this.getLastModified() != null) {
            json.put("modified", (Object)this.getLastModified());
        }
        if (FileType.SYMLINK.equals((Object)this.getType())) {
            json.put("linkPath", (Object)this.getLinkPath());
        }
        for (Object permissionView : this.getPermissionViews()) {
            if (permissionView instanceof UnixPermissions) {
                UnixPermissions unixPermissions = (UnixPermissions)permissionView;
                json.put("unixPermissions", (Object)this.getStringPermissions(unixPermissions));
                continue;
            }
            throw new JSONException("Unrecognized entry permission on entry " + this.getPath() + ", permission class " + permissionView.getClass());
        }
        List<Hash> additionalHashes = this.getAdditionalHashes();
        if (additionalHashes != null && !additionalHashes.isEmpty()) {
            JSONArray jsonHashes = new JSONArray();
            for (Hash hash : additionalHashes) {
                jsonHashes.put((Object)hash.toString());
            }
            json.put("additionalHashes", (Object)jsonHashes);
        }
        return json;
    }

    private String getStringPermissions(UnixPermissions permissions) {
        return permissions.getOctalMode() + ":" + permissions.getUser() + ":" + permissions.getGroup();
    }

    @Override
    public int compareTo(ClientPathEntry pathEntry) {
        return this.getPath().compareTo(pathEntry.getPath());
    }
}

