/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2013. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2020. All Rights Reserved.
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.release.rest.models.internal.TaskExecution
import com.urbancode.release.rest.models.internal.PluginIntegrationProvider
import org.codehaus.jettison.json.JSONObject;
import com.urbancode.urelease.integration.deploy.TaskExecutor;
import com.urbancode.release.rest.framework.Clients;

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties props = apTool.getStepProperties()

def releaseToken;
def serverUrl;
def ansibleHost;
def ansibleToken;
def integrationProviderId;
def extraProperties;
def taskProperties;

releaseToken = props['releaseToken'];
serverUrl = props['releaseServerUrl'];
ansibleHost = props['deployHostName'];
ansibleToken = props['deployToken'];
integrationProviderId = props['releaseIntegrationProvider'];
extraProperties = props['extraProperties'];
releaseAuthentication(releaseToken,serverUrl);
taskProperties = new JSONObject(extraProperties);

TaskExecutor executor = new TaskExecutor(taskProperties,ansibleHost,ansibleToken,serverUrl);

executor.executeTask();


//Authentication with Release
def releaseAuthentication (def releaseToken, def serverUrl) {
    Clients.loginWithToken(serverUrl, releaseToken, 0);
}
