/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.vfs.common.ClientObject;
import com.urbancode.vfs.common.ClientPathEntry;
import com.urbancode.vfs.common.Hash;
import java.util.HashMap;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ClientChangeSet
implements ClientObject {
    protected final String repositoryId;
    protected final String creator;
    protected final String comment;
    protected final ClientPathEntry[] entries;
    protected final Hash hash;
    protected final Hash parent;
    protected final Long createdDate;

    public static ClientChangeSet newChangeSet(String repoId, String creator, String comment, ClientPathEntry[] entries) {
        return new ClientChangeSet(repoId, creator, comment, entries, null, null, null);
    }

    public static ClientChangeSet fromJSON(JSONObject json) throws JSONException {
        String repositoryId = json.getString("repoId");
        String creator = json.getString("creator");
        String comment = json.getString("comment");
        ClientPathEntry[] entries = null;
        if (json.has("entries")) {
            JSONArray jsonEntries = json.getJSONArray("entries");
            entries = new ClientPathEntry[jsonEntries.length()];
            for (int i = 0; i < jsonEntries.length(); ++i) {
                JSONObject jsonEntry = jsonEntries.getJSONObject(i);
                entries[i] = ClientPathEntry.fromJSON(jsonEntry);
            }
        }
        Hash hash = null;
        Hash parent = null;
        Long createdDate = null;
        if (json.has("hash")) {
            hash = Hash.hashForString(json.getString("hash"));
            if (json.has("parent")) {
                parent = Hash.hashForString(json.getString("parent"));
            }
            createdDate = json.getLong("createdDate");
        }
        return new ClientChangeSet(repositoryId, creator, comment, entries, hash, parent, createdDate);
    }

    protected ClientChangeSet(String repositoryId, String creator, String comment, ClientPathEntry[] entries, Hash hash, Hash parent, Long createdDate) {
        this.repositoryId = repositoryId;
        this.creator = creator;
        this.comment = comment;
        this.entries = entries;
        this.hash = hash;
        this.parent = parent;
        this.createdDate = createdDate;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getComment() {
        return this.comment;
    }

    public ClientPathEntry[] getEntries() {
        return this.entries;
    }

    public Hash getHash() {
        return this.hash;
    }

    public Hash getParentHash() {
        return this.parent;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public ClientChangeSet addEntries(String creator, String comment, boolean overwrite, ClientPathEntry ... entries) {
        HashMap<String, ClientPathEntry> mergeMap = new HashMap<String, ClientPathEntry>();
        if (overwrite) {
            for (ClientPathEntry entry : this.getEntries()) {
                mergeMap.put(entry.getPath(), entry);
            }
            if (entries != null) {
                for (ClientPathEntry entry : entries) {
                    mergeMap.put(entry.getPath(), entry);
                }
            }
        } else {
            if (entries != null) {
                for (ClientPathEntry entry : entries) {
                    mergeMap.put(entry.getPath(), entry);
                }
            }
            for (ClientPathEntry entry : this.getEntries()) {
                mergeMap.put(entry.getPath(), entry);
            }
        }
        ClientPathEntry[] newEntries = mergeMap.values().toArray(new ClientPathEntry[0]);
        return new ClientChangeSet(this.getRepositoryId(), creator, comment, newEntries, null, null, null);
    }

    public ClientChangeSet removeEntries(String ... paths) {
        HashMap<String, ClientPathEntry> mergeMap = new HashMap<String, ClientPathEntry>();
        for (ClientPathEntry entry : this.getEntries()) {
            mergeMap.put(entry.getPath(), entry);
        }
        if (paths != null) {
            for (String path : paths) {
                mergeMap.remove(path);
            }
        }
        ClientPathEntry[] newEntries = mergeMap.values().toArray(new ClientPathEntry[0]);
        return new ClientChangeSet(this.getRepositoryId(), null, null, newEntries, null, null, null);
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("repoId", (Object)this.getRepositoryId());
        if (this.parent != null) {
            json.put("parent", (Object)this.parent.toString());
        }
        json.put("creator", (Object)this.getCreator());
        if (this.createdDate != null) {
            json.put("createdDate", (Object)this.createdDate);
        }
        json.put("comment", (Object)this.getComment());
        JSONArray entryArray = new JSONArray();
        for (ClientPathEntry entry : this.getEntries()) {
            JSONObject jsonEntry = entry.toJSON();
            entryArray.put((Object)jsonEntry);
        }
        json.put("entries", (Object)entryArray);
        return json;
    }
}

