/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.commons.fileutils.digest.DigestUtil;
import com.urbancode.vfs.common.Encoding;
import com.urbancode.vfs.common.EncodingUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hash
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String value;
    private final Encoding encoding;
    private transient byte[] bytes;

    public static Hash hashForFile(File file, String algorithm) throws NoSuchAlgorithmException, IOException {
        String value = DigestUtil.getHexDigest((File)file, (String)algorithm);
        return new Hash(algorithm, value, Encoding.Hex);
    }

    public static List<Hash> hashesForFile(File file, String ... algorithms) throws NoSuchAlgorithmException, IOException {
        ArrayList<Hash> hashList = new ArrayList<Hash>();
        List values = DigestUtil.getHexDigests((File)file, (String[])algorithms);
        for (int i = 0; i < algorithms.length; ++i) {
            hashList.add(new Hash(algorithms[i], (String)values.get(i), Encoding.Hex));
        }
        return hashList;
    }

    public static Hash hashForInputStream(InputStream input, String algorithm) throws NoSuchAlgorithmException, IOException {
        String value = DigestUtil.getHexDigest((InputStream)input, (String)algorithm);
        return new Hash(algorithm, value, Encoding.Hex);
    }

    public static List<Hash> hashesForInputStream(InputStream input, String ... algorithms) throws NoSuchAlgorithmException, IOException {
        ArrayList<Hash> hashList = new ArrayList<Hash>();
        List values = DigestUtil.getHexDigests((InputStream)input, (String[])algorithms);
        for (int i = 0; i < algorithms.length; ++i) {
            hashList.add(new Hash(algorithms[i], (String)values.get(i), Encoding.Hex));
        }
        return hashList;
    }

    public static Hash hashForStringContent(String content, String algorithm) throws NoSuchAlgorithmException, IOException {
        String value = DigestUtil.getHexDigest((byte[])content.getBytes("UTF-8"), (String)algorithm);
        return new Hash(algorithm, value, Encoding.Hex);
    }

    public static List<Hash> hashesForStringContent(String content, String ... algorithms) throws NoSuchAlgorithmException, IOException {
        ArrayList<Hash> hashList = new ArrayList<Hash>();
        List values = DigestUtil.getHexDigests((byte[])content.getBytes("UTF-8"), (String[])algorithms);
        for (int i = 0; i < algorithms.length; ++i) {
            hashList.add(new Hash(algorithms[i], (String)values.get(i), Encoding.Hex));
        }
        return hashList;
    }

    public static Hash hashForString(String hashString) {
        String algorithm = DigestUtil.parseDigestAlgorithm((String)hashString);
        String hashValue = DigestUtil.parseDigestHex((String)hashString);
        Encoding encoding = Encoding.Hex;
        try {
            Hex.decodeHex((char[])hashValue.toCharArray());
        }
        catch (Exception e) {
            encoding = Encoding.Base64;
        }
        return new Hash(algorithm, hashValue, encoding);
    }

    public static Hash hashForMessageDigest(MessageDigest md) {
        String hex = new String(Hex.encodeHex((byte[])md.digest()));
        return new Hash(md.getAlgorithm(), hex, Encoding.Hex);
    }

    public Hash(String algorithm, String value, Encoding encoding) {
        this.algorithm = algorithm;
        this.value = value;
        this.encoding = encoding;
        try {
            EncodingUtil util = new EncodingUtil();
            this.bytes = util.decode(this);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Invalid value", e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getValue() {
        return this.value;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toString() {
        return this.getAlgorithm() + "{" + this.getValue() + "}";
    }

    public int hashCode() {
        return this.getAlgorithm().hashCode() + this.getValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Hash) {
            Hash hash = (Hash)obj;
            return this.getAlgorithm().equals(hash.getAlgorithm()) && this.getValue().equals(hash.getValue());
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            EncodingUtil util = new EncodingUtil();
            this.bytes = util.decode(this);
        }
        catch (DecoderException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }
}

