/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientIntegrated;
import org.apache.log4j.Level;

public class Settings
extends ClientIntegrated<Settings> {
    public Settings() {
        this.path = "/settings/";
    }

    public String getLog4jFileText() {
        String text = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + "logConfig", new Object[0])).asString();
        return text;
    }

    public void saveLog4jFileText(String text) {
        JsonObject json = new JsonObject();
        json.addProperty("logConfig", text);
        this.query.apply(RestAssured.given()).body((Object)json, ObjectMapperType.GSON).put(this.path() + "logConfig", new Object[0]);
    }

    public boolean isLoggingEnabled(String className, Level level) {
        String jsonString = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + "checkLogging?className=" + className, new Object[0])).asString();
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(jsonString).getAsJsonObject();
        return json.get("level").getAsString().equals(level.toString());
    }

    public String getOutputLogsText(long startLine) {
        String jsonString = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.TEXT).when().get(this.path() + "outputLogs?startLine=" + startLine, new Object[0])).asString();
        JsonParser parser = new JsonParser();
        return parser.parse(jsonString).getAsJsonObject().get("lines").getAsString();
    }

    public long getOutputLogLines() {
        String jsonString = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + "outputLogLines", new Object[0])).asString();
        JsonParser parser = new JsonParser();
        return parser.parse(jsonString).getAsJsonObject().get("totalLines").getAsLong();
    }

    public JsonObject getSystemSettings() {
        String jsonString = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + "systemProperties", new Object[0])).asString();
        JsonParser parser = new JsonParser();
        return parser.parse(jsonString).getAsJsonObject();
    }

    public void saveSystemSettings(JsonObject json) {
        this.query.apply(RestAssured.given()).body((Object)json, ObjectMapperType.GSON).put(this.path() + "systemProperties", new Object[0]);
    }

    public String getPublicURL() {
        String publicURL = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.TEXT).when().get(this.path() + "systemProperties/getPublicURL", new Object[0])).asString();
        return publicURL;
    }

    public String getLicenseServerURL() {
        String licenseServerURL = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.TEXT).when().get(this.path() + "systemProperties/getLicenseServerURL", new Object[0])).asString();
        return licenseServerURL;
    }

    public boolean isFlagEnabled(String flag) {
        String jsonString = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + "systemProperties/isFlagEnabled?flag=" + flag, new Object[0])).asString();
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(jsonString).getAsJsonObject();
        return json.get("isEnabled").getAsBoolean();
    }

    public String getTestingColumn(Integer index) {
        String text = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.TEXT).when().get(this.path() + "systemProperties/getTestingColumn?index=" + index, new Object[0])).asString();
        return text;
    }
}

