/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.internal.Deployment;
import com.urbancode.release.rest.models.internal.DeploymentNotification;
import com.urbancode.release.rest.models.internal.DeploymentPlan;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.SegmentExecution;
import com.urbancode.release.rest.models.internal.SuggestedTask;
import java.util.EnumSet;

public class DeploymentExecution
extends Deployment<DeploymentExecution> {
    @JsonReadOnly
    public ScheduledDeployment scheduledDeployment;
    @JsonReadOnly
    public DeploymentPlan deploymentPlan;
    @JsonReadOnly
    public Boolean syncSegments;
    @JsonReadOnly
    public String status;
    @JsonReadOnly
    public Boolean locked;
    @JsonReadOnly
    public Long startTimeActual;
    @JsonReadOnly
    public Long endTimePlanned;
    @JsonReadOnly
    public Long endTimeEstimated;
    @JsonReadOnly
    public Long endTimeActual;
    @JsonReadOnly
    public SegmentExecution[] segments;
    @JsonReadOnly
    public DeploymentNotification[] notifications;
    @JsonReadOnly
    public SuggestedTask[] suggestedTasks;
    @Deprecated
    @JsonReadOnly
    public User currentUser;

    public DeploymentExecution() {
        this.path = "/deploymentExecutions/";
    }

    public String getStatus() {
        return this.status;
    }

    public Long getEndTimeEstimated() {
        return this.endTimeEstimated;
    }

    public void invalidateCache() {
        RestAssured.given().expect().statusCode(204).post(this.path + this.id + "/invalidateCache", new Object[0]);
    }

    public static enum DeploymentStatus {
        EMPTY,
        NOTSTARTED,
        INPROGRESS,
        SOFTFAILED,
        FAILED,
        COMPLETE,
        ABORTED;


        public static EnumSet<DeploymentStatus> forUpcoming() {
            return EnumSet.of(EMPTY, NOTSTARTED, INPROGRESS);
        }
    }
}

