/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.CheckpointExecution;
import com.urbancode.release.rest.models.internal.SegmentExecution;
import com.urbancode.release.rest.models.internal.Task;
import com.urbancode.release.rest.models.internal.TaskExecutionUpdate;
import java.util.ArrayList;

public class TaskExecution
extends Task<TaskExecution> {
    public String status;
    public String result;
    public String externalResult;
    public String externalStatus;
    public TaskExecutionUpdate[] taskUpdates;
    @JsonReadOnly
    public Boolean isReady;
    @JsonReadOnly
    public Long lastRefresh;
    @JsonReadOnly
    public Boolean syncProperties;
    @JsonReadOnly
    public Boolean isApplicable;
    @JsonReadOnly
    public TaskExecution[] prerequisites;
    @JsonReadOnly
    public CheckpointExecution checkpointExecution;
    @JsonReadOnly
    public Long startTimeActual;
    @JsonReadOnly
    public Long startTimePlanned;
    @JsonReadOnly
    public Long startTimeEstimated;
    @JsonReadOnly
    public Long endTimeActual;

    public TaskExecution() {
        this.path = "/taskExecutions/";
    }

    public boolean isSucceded() {
        if (this.result != null) {
            return this.result.equals(Result.SUCCESS.toString());
        }
        return true;
    }

    public TaskExecution setStatus(Status status) {
        return this.status(status);
    }

    public TaskExecution status(Status status) {
        this.status = status.toString();
        return this;
    }

    public TaskExecution taskUpdates(TaskExecutionUpdate[] updates) {
        this.taskUpdates = updates;
        return this;
    }

    public TaskExecution setTaskUpdate(TaskExecutionUpdate[] updates) {
        this.taskUpdates(updates);
        return this;
    }

    public TaskExecutionUpdate[] getTaskUpdates() {
        return this.taskUpdates;
    }

    public TaskExecution setResult(Result result) {
        return this.result(result);
    }

    public TaskExecution result(Result result) {
        this.result = result.toString();
        return this;
    }

    public TaskExecution externalResult(ExternalResult result) {
        this.externalResult = result.toString();
        return this;
    }

    public TaskExecution setExternalResult(ExternalResult result) {
        return this.externalResult(result);
    }

    public TaskExecution externalStatus(ExternalStatus externalStatus) {
        this.externalStatus = externalStatus.toString();
        return this;
    }

    public TaskExecution setExternalStatus(ExternalStatus status) {
        return this.externalStatus(status);
    }

    public String getExternalResult() {
        return this.externalResult;
    }

    public String getExternalStatus() {
        return this.externalStatus;
    }

    public TaskExecution addPrerequisites(TaskExecution ... prerequisites) {
        return this.addPrerequisites(200, prerequisites);
    }

    public TaskExecution addPrerequisites(int statusCode, TaskExecution ... prerequisites) {
        JsonArray ids = new JsonArray();
        for (TaskExecution prereq : prerequisites) {
            ids.add(new JsonPrimitive(prereq.getId()));
        }
        String json = ids.toString();
        RestAssured.given().body(json).expect().statusCode(statusCode).post(this.path(this.id) + "/prerequisites", new Object[0]);
        return (TaskExecution)this.get();
    }

    public TaskExecution removePrerequisites(TaskExecution ... prerequisites) {
        JsonArray ids = new JsonArray();
        for (TaskExecution prereq : prerequisites) {
            ids.add(new JsonPrimitive(prereq.getId()));
        }
        String json = ids.toString();
        RestAssured.given().body(json).delete(this.path(this.id) + "/prerequisites", new Object[0]);
        return (TaskExecution)this.get();
    }

    public TaskExecution claim() {
        RestAssured.given().put(this.path(this.id) + "/claim", new Object[0]);
        return this;
    }

    public TaskExecution start() {
        RestAssured.given().put(this.path(this.id) + "/start", new Object[0]);
        return this;
    }

    public TaskExecution startExpectForbidden() {
        RestAssured.given().expect().statusCode(403).when().put(this.path(this.id) + "/start", new Object[0]);
        return this;
    }

    public TaskExecution startOverride() {
        RestAssured.given().put(this.path(this.id) + "/startOverride", new Object[0]);
        return this;
    }

    public TaskExecution complete() {
        RestAssured.given().put(this.path(this.id) + "/complete", new Object[0]);
        return this;
    }

    public TaskExecution completeOverride() {
        RestAssured.given().put(this.path(this.id) + "/completeOverride", new Object[0]);
        return this;
    }

    public TaskExecution skip() {
        RestAssured.given().put(this.path(this.id) + "/skip", new Object[0]);
        return this;
    }

    public TaskExecution skipOverride() {
        RestAssured.given().put(this.path(this.id) + "/skipOverride", new Object[0]);
        return this;
    }

    public TaskExecution reopen() {
        RestAssured.given().put(this.path(this.id) + "/reopen", new Object[0]);
        return this;
    }

    public TaskExecution fail() {
        RestAssured.given().put(this.path(this.id) + "/fail", new Object[0]);
        return this;
    }

    public TaskExecution failOverride() {
        RestAssured.given().put(this.path(this.id) + "/failOverride", new Object[0]);
        return this;
    }

    public TaskExecution[] getAllExecutingForProvider(String integrationProviderId) {
        return ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + integrationProviderId + "/allExecutingTasks", new Object[0])).as(TaskExecution[].class, ObjectMapperType.GSON);
    }

    public TaskExecution[] saveExecutingTasks(TaskExecution[] executingTasks) {
        TaskExecution[] response = (TaskExecution[])((Response)this.query.apply(RestAssured.given()).body((Object)executingTasks, ObjectMapperType.GSON).expect().statusCode(200).when().put(this.path() + "updateExecutingTasks", new Object[0])).as(this.arrayClass(), ObjectMapperType.GSON);
        return response;
    }

    @Override
    public TaskExecution save() {
        log.debug("save()");
        if (this.id == null) {
            this.post();
            return this;
        }
        this.put();
        return (TaskExecution)this.get();
    }

    public TaskExecution addToSegmentExpectingStatus(SegmentExecution segment, int status) {
        ArrayList<String> taskIds = new ArrayList<String>();
        for (TaskExecution oldTask : segment.tasks) {
            taskIds.add(oldTask.id);
        }
        RestAssured.given().expect().statusCode(status).when().post(segment.path(segment.id) + "/tasks/" + this.id, new Object[0]);
        TaskExecution[] newTasks = ((SegmentExecution)segment.get()).tasks;
        if (newTasks.length > taskIds.size()) {
            for (TaskExecution newTask : newTasks) {
                if (taskIds.contains(newTask.id)) continue;
                this.id = newTask.id;
                break;
            }
        }
        return this;
    }

    public TaskExecution addProperty(String name, String value) {
        return (TaskExecution)this.property(name, value);
    }

    public static enum ExternalResult {
        NONE,
        SUCCEEDED,
        CANCELED,
        FAULTED;

    }

    public static enum Result {
        SUCCESS,
        FAILURE,
        SKIPPED,
        NOT_APPLICABLE;

    }

    public static enum ExternalStatus {
        PLANNED,
        OPEN,
        EXECUTING,
        CLOSED;

    }

    public static enum Status {
        PLANNED,
        OPEN,
        EXECUTING,
        CLOSED;

    }
}

